/*
 * Decompiled with CFR 0.152.
 */
package cn.com.digitalhainan.apione.sdk;

import cn.com.digitalhainan.apione.sdk.ContentBody;
import cn.com.digitalhainan.apione.sdk.HttpCaller;
import cn.com.digitalhainan.apione.sdk.HttpParameters;
import cn.com.digitalhainan.apione.sdk.HttpReturn;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class ApioneSignature {
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String X_API_NAME_KEY = "_api_name";
    public static final String X_API_ACCESS_KEY = "_api_access_key";
    public static final String X_API_SIGNATURE = "_api_signature";
    public static final String X_API_TIMESTAMP = "_api_timestamp";
    public static final String X_API_VERSION = "_api_version";
    public static final String HMACSHA1 = "HmacSHA1";
    public static final String version = "1.0";

    public static String sign(String apiName, String accessKey, long timeStamp, String secretKey, Map<String, String> formParamMap, String version) {
        TreeMap<String, String> sortedParamMap = new TreeMap<String, String>();
        sortedParamMap.put(X_API_NAME_KEY, apiName);
        sortedParamMap.put(X_API_VERSION, version);
        sortedParamMap.put(X_API_ACCESS_KEY, accessKey);
        sortedParamMap.put(X_API_TIMESTAMP, timeStamp + "");
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : sortedParamMap.entrySet()) {
            builder.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append("&");
        }
        String str = builder.toString();
        if (str.endsWith("&")) {
            str = str.substring(0, str.length() - 1);
        }
        try {
            Mac mac = Mac.getInstance(HMACSHA1);
            mac.init(new SecretKeySpec(secretKey.getBytes(CHARSET_UTF8), HMACSHA1));
            return Base64.encode(mac.doFinal(str.getBytes(CHARSET_UTF8))).trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("NoSuchAlgorithm: HmacSHA1", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("secretKey invalidate", e);
        }
    }

    public static void main(String[] args) {
        Date date = new Date();
        String contentJson = "\u5165\u53c2\u7684\u8bf7\u6c42\u53c2\u6570";
        String ak = "\u6211\u7684\u5e94\u7528-\u6211\u7533\u8bf7\u7684\u529f\u80fd-\u5bf9\u5e94\u529f\u80fd\u67e5\u770bak";
        String sk = "\u6211\u7684\u5e94\u7528-\u6211\u7533\u8bf7\u7684\u529f\u80fd-\u5bf9\u5e94\u529f\u80fd\u67e5\u770bsk";
        String api = "\u63a5\u53e3api name";
        String region = "\u63a5\u53e3\u8bf7\u6c42\u533a\u57df INTRA(\u653f\u52a1\u5916\u7f51),INTER(\u653f\u52a1\u4e92\u8054\u7f51),PUBLIC(\u516c\u7f51)";
        String requestUrl = "\u6587\u6863\u4e0a\u65b9\u8bf7\u6c42\u5730\u5740";
        ContentBody contentBody = new ContentBody(contentJson);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("name", "zx");
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("key", "value");
        HttpParameters parameters = HttpParameters.builder().api(api).region(region).headerParamsMap(header).queryParamsMap(query).path("/path1/path2").accessKey(ak).secretKey(sk).contentBody(contentBody).requestUrl(requestUrl).build();
        HttpReturn call = HttpCaller.getInstance().call(parameters);
        System.out.println(call);
        System.out.println(new Date().getTime());
        System.out.println(new Date().getTime() - date.getTime() + "");
    }
}

