/*
 * Decompiled with CFR 0.152.
 */
package cn.com.digitalhainan.apione.sdk;

import cn.com.digitalhainan.apione.sdk.ApioneSignature;
import cn.com.digitalhainan.apione.sdk.HttpByteReturn;
import cn.com.digitalhainan.apione.sdk.HttpParameters;
import cn.com.digitalhainan.apione.sdk.HttpReturn;
import cn.com.digitalhainan.apione.utils.LogUtils;
import cn.com.digitalhainan.apione.utils.ObjectUtils;
import cn.com.digitalhainan.apione.utils.SSLSocketClientUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;

public class HttpCaller {
    private static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
    public static final String CONNECT_TIMEOUT_KEY = "apione.http.connect.timeout";
    public static final String READ_TIMEOUT_KEY = "apione.http.read.timeout";
    public static final String WRITE_TIMEOUT_KEY = "apione_http.write.timeout";
    public static final String MAX_IDLE_CONNECTIONS = "apione_http.maxIdleConnections";
    private static final String REGION_KEY = "region";
    private static final String REQUEST_ID = "x-request-id";
    private static final String PATH_KEY = "x-http-path";
    private static final String QUERY_KEY = "x-http-query";
    public static final String REQUEST_ID_MDC_KEY = "requestId";
    private OkHttpClient client;

    private HttpCaller() {
        X509TrustManager manager = SSLSocketClientUtil.getX509TrustManager();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.sslSocketFactory(SSLSocketClientUtil.getSocketFactory(manager), manager).hostnameVerifier(SSLSocketClientUtil.getHostnameVerifier());
        builder.connectTimeout(Integer.parseInt(System.getProperty(CONNECT_TIMEOUT_KEY, "60")), TimeUnit.SECONDS);
        builder.readTimeout(Integer.parseInt(System.getProperty(READ_TIMEOUT_KEY, "60")), TimeUnit.SECONDS);
        builder.writeTimeout(Integer.parseInt(System.getProperty(WRITE_TIMEOUT_KEY, "60")), TimeUnit.SECONDS);
        builder.connectionPool(new ConnectionPool(Integer.parseInt(System.getProperty(MAX_IDLE_CONNECTIONS, "50")), 5L, TimeUnit.MINUTES));
        this.client = builder.build();
    }

    public static HttpCaller getInstance() {
        return OkHttpHolder.INSTANCE;
    }

    public HttpReturn call(HttpParameters httpParameters) {
        Request request = this.getRequest(httpParameters);
        HttpReturn httpReturn = new HttpReturn();
        try {
            Response response = this.client.newCall(request).execute();
            httpReturn.setResponseHttpStatus(response.code()).setResponse(response.body().string());
            this.setResponseHeader(response, httpReturn.getRespHttpHeaderMap());
            return httpReturn;
        }
        catch (IOException e) {
            LogUtils.error("call url:{} api:{} error:{}", httpParameters.getRequestUrl(), httpParameters.getApi(), e.getMessage());
            return httpReturn;
        }
    }

    private void setResponseHeader(Response response, Map<String, String> respHttpHeaderMap) {
        response.headers().toMultimap().forEach((key, values) -> {
            String cfr_ignored_0 = (String)respHttpHeaderMap.put((String)key, (String)values.get(0));
        });
    }

    public HttpByteReturn callByte(HttpParameters httpParameters) {
        Request request = this.getRequest(httpParameters);
        HttpByteReturn httpReturn = new HttpByteReturn();
        try {
            Response response = this.client.newCall(request).execute();
            httpReturn.setResponseHttpStatus(response.code()).setResponse(response);
            this.setResponseHeader(response, httpReturn.getRespHttpHeaderMap());
            return httpReturn;
        }
        catch (IOException e) {
            LogUtils.error("call url:{} api:{} error:{}", httpParameters.getRequestUrl(), httpParameters.getApi(), e.getMessage());
            return httpReturn;
        }
    }

    private Request getRequest(HttpParameters httpParameters) {
        this.assertParams(httpParameters);
        String sign = ApioneSignature.sign(httpParameters.getApi(), httpParameters.getAccessKey(), httpParameters.getDate().getTime(), httpParameters.getSecretKey(), httpParameters.getFormParamsMap(), httpParameters.getVersion());
        RequestBody body = null;
        if (httpParameters.getContentBody() != null) {
            body = RequestBody.create(httpParameters.getMediaType(), httpParameters.getContentBody().getJsonBody());
        } else if (httpParameters.getMediaType().toString().toLowerCase().contains("form")) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(httpParameters.getMediaType());
            if (!ObjectUtils.isEmpty(httpParameters.getFormParamsMap())) {
                httpParameters.getFormParamsMap().forEach(builder::addFormDataPart);
            }
            if (!ObjectUtils.isEmpty(httpParameters.getAttachFileMaps())) {
                httpParameters.getAttachFileMaps().forEach((key, attachFile) -> builder.addFormDataPart((String)key, attachFile.getFileName(), RequestBody.create(attachFile.getMediaType(), attachFile.getFileBytes())));
            }
            body = builder.build();
        }
        if (body == null && HttpMethod.requiresRequestBody(httpParameters.getMethod())) {
            body = RequestBody.create(httpParameters.getMediaType(), "");
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse(httpParameters.getRequestUrl()).newBuilder();
        Request.Builder builder = new Request.Builder().method(httpParameters.getMethod(), body);
        if (!ObjectUtils.isEmpty(httpParameters.getQueryParamsMap())) {
            httpParameters.getQueryParamsMap().forEach(urlBuilder::addQueryParameter);
        }
        TreeMap<String, String> sortedHeaderMap = new TreeMap<String, String>(this.commonHeader(httpParameters, sign));
        if (httpParameters.getHeaderParamsMap() != null) {
            sortedHeaderMap.putAll(httpParameters.getHeaderParamsMap());
        }
        sortedHeaderMap.forEach(builder::header);
        Request request = builder.url(urlBuilder.build()).build();
        return request;
    }

    public static String map2Form(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map == null) {
            return stringBuilder.toString();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private void assertParams(HttpParameters httpParameters) {
        if (httpParameters.getMethod() == null) {
            httpParameters.setMethod("POST");
        }
        if (httpParameters.getMediaType() == null) {
            httpParameters.setMediaType(JSON);
        }
        if (httpParameters.getDate() == null) {
            httpParameters.setDate(new Date());
        }
        if (ObjectUtils.isEmpty(httpParameters.getVersion())) {
            httpParameters.setVersion("1.0");
        }
        if (ObjectUtils.isEmpty(httpParameters.getAccessKey())) {
            throw new RuntimeException("Miss ak");
        }
        if (ObjectUtils.isEmpty(httpParameters.getSecretKey())) {
            throw new RuntimeException("Miss sk");
        }
        if (ObjectUtils.isEmpty(httpParameters.getApi())) {
            throw new RuntimeException("Miss api name");
        }
        if (ObjectUtils.isEmpty(httpParameters.getRequestUrl())) {
            throw new RuntimeException("Miss request url");
        }
    }

    private Map<String, String> commonHeader(HttpParameters httpParameters, String sign) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("_api_name", httpParameters.getApi());
        headerMap.put("_api_access_key", httpParameters.getAccessKey());
        headerMap.put("_api_signature", sign);
        headerMap.put("_api_version", httpParameters.getVersion());
        headerMap.put("_api_timestamp", httpParameters.getDate().getTime() + "");
        String requestId = LogUtils.mdcGet(REQUEST_ID_MDC_KEY);
        if (ObjectUtils.isEmpty(requestId)) {
            requestId = UUID.randomUUID().toString().replaceAll("-", "");
        }
        headerMap.put(REQUEST_ID, requestId);
        LogUtils.info("apione trace api = {} ,requestId = {}", httpParameters.getApi(), requestId);
        if (!ObjectUtils.isEmpty(httpParameters.getRegion())) {
            headerMap.put(REGION_KEY, httpParameters.getRegion());
        }
        if (!ObjectUtils.isEmpty(httpParameters.getPath())) {
            if (!httpParameters.getPath().startsWith("/")) {
                httpParameters.setPath("/" + httpParameters.getPath());
            }
            headerMap.put(PATH_KEY, httpParameters.getPath());
        }
        return headerMap;
    }

    private String getUrlParamsByMap(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = ObjectUtils.substringBeforeLast(s, "&");
        }
        return s;
    }

    private static class OkHttpHolder {
        private static final HttpCaller INSTANCE = new HttpCaller();

        private OkHttpHolder() {
        }
    }
}

