/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.BaseQueryKey;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.CallableQueryKey;
import com.kingbase8.core.JdbcCallParseInfo;
import com.kingbase8.core.NativeQuery;
import com.kingbase8.core.Parser;
import com.kingbase8.core.Query;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.QueryWithReturningColumnsKey;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.util.LruCache;
import com.kingbase8.util.TraceLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutorImpl;
    public static final Pattern INTO_REGEX = Pattern.compile("\\sINTO\\s", 2);
    public static final Pattern CREATE_REGEX = Pattern.compile("[\\s]*CREATE\\s", 2);
    public static final Pattern SELECT_REGEX = Pattern.compile("[\\s]*SELECT\\s", 2);
    public static final Pattern JOIN_REGEX = Pattern.compile("\\sJOIN\\s", 2);
    public static final Pattern FROMRESULT_REGEX = Pattern.compile("\\sFROM[\\s]*\\(", 2);
    public static final Pattern MULTITABLE_REGEX = Pattern.compile("\\sFROM\\s\\S+[\\s]*(as)?([\\s]*\\S+[\\s]*)?,", 2);
    public static final Pattern FOR_UPDATE_REGEX = Pattern.compile("\\sFOR[\\s]+UPDATE[\\s]*", 2);
    public static final Pattern BEGIN_REGEX = Pattern.compile("[\\s]*BEGIN\\s", 2);
    public static final Pattern PLSQL_TYPE_BODY_REGEX = Pattern.compile("[\\s]*CREATE([\\s]+OR[\\s]+REPLACE)?([\\s]+(NON)?EDITIONABLE)?[\\s]+TYPE[\\s]+BODY[\\s]+([^\\s]*[\\s]+)?(IS|AS)\\s", 2);
    public static final Pattern PLSQL_PACKAGE_BODY_REGEX = Pattern.compile("[\\s]*CREATE([\\s]+OR[\\s]+REPLACE)?([\\s]+(NON)?EDITIONABLE)?[\\s]+PACKAGE[\\s]+BODY[\\s]+([^\\s]*[\\s]+)?(IS|AS)\\s", 2);
    public static final Pattern PLSQL_PACKAGE_DEFINITION_REGEX = Pattern.compile("[\\s]*CREATE([\\s]+OR[\\s]+REPLACE)?([\\s]+(NON)?EDITIONABLE)?[\\s]+PACKAGE[\\s]+([^\\s]*[\\s]+)?(IS|AS)\\s", 2);

    CachedQueryCreateAction(QueryExecutor queryExecutorImpl) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorImpl = queryExecutorImpl;
    }

    @Override
    public CachedQuery create(Object _key) throws SQLException {
        String[] returningColumns;
        boolean outParmBeforeFunc;
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        assert (_key instanceof String || _key instanceof BaseQueryKey) : "Query _key should be String or BaseQueryKey. Given " + _key.getClass() + ", _sql: " + String.valueOf(_key);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_key instanceof BaseQueryKey) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            queryKey = (BaseQueryKey)_key;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            parsedSql = queryKey.sqlString;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            queryKey = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            parsedSql = (String)_key;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        if (_key instanceof String || queryKey != null && queryKey.escapeProcessingT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.queryExecutorImpl.getStandardConformingStrings(), this.queryExecutorImpl.getCompatibleLevel(), this.queryExecutorImpl.getUnpairedComment());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String schemaName = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String funName = null;
        String origFunName = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.queryExecutorImpl.getStandardConformingStrings(), this.queryExecutorImpl.getServerVersionNum(), this.queryExecutorImpl.getProtocolVersion(), this.queryExecutorImpl.getEscapeSyntaxCallMode(), this.queryExecutorImpl.getStoreCase(), this.queryExecutorImpl.getCompatibleLevel(), this.queryExecutorImpl.getUnpairedComment());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_key instanceof CallableQueryKey) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            parsedSql = callInfo.getSql();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            isFunction = callInfo.isFunction();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            outParmBeforeFunc = callInfo.isOutParmBeforeFunc();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            schemaName = callInfo.getSchemaName();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            funName = callInfo.getFunName();
            origFunName = callInfo.getOrigFuncName();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            parsedSql = callInfo.getSql();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            isFunction = false;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            outParmBeforeFunc = false;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean isParameterized = _key instanceof String || queryKey != null && queryKey.isParameterizedT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean splitStatements = isParameterized || this.queryExecutorImpl.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_key instanceof QueryWithReturningColumnsKey) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            returningColumns = ((QueryWithReturningColumnsKey)_key)._columnNames;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            returningColumns = EMPTY_RETURNING;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.queryExecutorImpl.getStandardConformingStrings(), isParameterized, splitStatements, this.queryExecutorImpl.isReWriteBatchedInsertsEnabled(), this.queryExecutorImpl.getCompatibleLevel(), this.queryExecutorImpl.getUnpairedComment(), returningColumns);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.addPrimaryKeys(queries);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Query query = this.queryExecutorImpl.wrap(queries);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new CachedQuery(_key, query, isFunction, outParmBeforeFunc, schemaName, funName, origFunName);
    }

    void addPrimaryKeys(List<NativeQuery> queries) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < queries.size(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            NativeQuery _nativeQuery = queries.get(i);
            String todo = _nativeQuery.nativeSql;
            if (this.isPl_sql(todo) || !this.hasForUpdate(todo)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder sbu = new StringBuilder();
            StringTokenizer st = new StringTokenizer(todo, ";");
            while (st.hasMoreTokens()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String str = st.nextToken();
                if (this.isAdd(str)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _nativeQuery.forupdate = true;
                    StringBuffer sbuf = new StringBuffer();
                    Pattern _flag2 = Pattern.compile("select\\s", 2);
                    Matcher matcher2 = _flag2.matcher(str);
                    if (matcher2.find()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        matcher2.appendReplacement(sbuf, "select ctid,xmin,");
                    }
                    matcher2.appendTail(sbuf);
                    sbu.append(sbuf.toString() + ";");
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (_nativeQuery._bindPositions == null || _nativeQuery._bindPositions.length == 0) continue;
                    int j = 0;
                    while (j < _nativeQuery._bindPositions.length) {
                        int n = j++;
                        _nativeQuery._bindPositions[n] = _nativeQuery._bindPositions[n] + 10;
                    }
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append(str + ";");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _nativeQuery.nativeSql = sbu.toString();
        }
    }

    boolean isAdd(String _sql) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return !INTO_REGEX.matcher(_sql).find() && !CREATE_REGEX.matcher(_sql).find() && !JOIN_REGEX.matcher(_sql).find() && !FROMRESULT_REGEX.matcher(_sql).find() && !MULTITABLE_REGEX.matcher(_sql).find() && this.hasForUpdate(_sql);
    }

    boolean hasForUpdate(String _sql) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return SELECT_REGEX.matcher(_sql).find() && FOR_UPDATE_REGEX.matcher(_sql).find();
    }

    boolean isPl_sql(String _sql) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return BEGIN_REGEX.matcher(_sql).find() || PLSQL_TYPE_BODY_REGEX.matcher(_sql).find() || PLSQL_PACKAGE_BODY_REGEX.matcher(_sql).find() || PLSQL_PACKAGE_DEFINITION_REGEX.matcher(_sql).find();
    }
}

