/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.hostchooser;

import com.kingbase8.hostchooser.HostRequirement;
import com.kingbase8.hostchooser.HostStatus;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.TraceLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class GlobalHostStatusTracker {
    private static final Map<HostSpec, HostSpecStatus> _hostStatusMap = new HashMap<HostSpec, HostSpecStatus>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportHostStatus(HostSpec _hostSpec, HostStatus _hostStatus) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long now = System.nanoTime() / 1000L;
        Map<HostSpec, HostSpecStatus> map = _hostStatusMap;
        synchronized (map) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            HostSpecStatus _hostSpecStatus = _hostStatusMap.get(_hostSpec);
            if (_hostSpecStatus == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _hostSpecStatus = new HostSpecStatus(_hostSpec);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _hostStatusMap.put(_hostSpec, _hostSpecStatus);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _hostSpecStatus.status = _hostStatus;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _hostSpecStatus.lastUpdated = now;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<HostSpec> getCandidateHosts(HostSpec[] _hostSpecs, HostRequirement targetServerType, long _hostRecheckMillis, boolean fastFailover) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<HostSpec> candidates = new ArrayList<HostSpec>(_hostSpecs.length);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long latestAllowedUpdate = System.nanoTime() / 1000L - _hostRecheckMillis;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Map<HostSpec, HostSpecStatus> map = _hostStatusMap;
        synchronized (map) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (HostSpec _hostSpec : _hostSpecs) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                HostSpecStatus _hostInfo = _hostStatusMap.get(_hostSpec);
                if (fastFailover) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (_hostInfo != null && _hostInfo.status == HostStatus.First) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        candidates.add(0, _hostSpec);
                        continue;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    candidates.add(_hostSpec);
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_hostInfo != null && _hostInfo.lastUpdated >= latestAllowedUpdate && !targetServerType.allowConnectingTo(_hostInfo.status)) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                candidates.add(_hostSpec);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return candidates;
    }

    static class HostSpecStatus {
        final HostSpec _host;
        HostStatus status;
        long lastUpdated;

        HostSpecStatus(HostSpec _host) {
            this._host = _host;
        }

        public String toString() {
            return this._host.toString() + '=' + (Object)((Object)this.status);
        }
    }
}

