/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.hostchooser;

import com.kingbase8.hostchooser.HostStatus;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

public enum HostRequirement {
    any{

        @Override
        public boolean allowConnectingTo(HostStatus hostStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return hostStatus != HostStatus.ConnectFail;
        }
    }
    ,
    master{

        @Override
        public boolean allowConnectingTo(HostStatus hostStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return hostStatus == HostStatus.Master || hostStatus == HostStatus.ConnectOK || hostStatus == HostStatus.First;
        }
    }
    ,
    secondary{

        @Override
        public boolean allowConnectingTo(HostStatus hostStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return hostStatus == HostStatus.Secondary || hostStatus == HostStatus.ConnectOK || hostStatus == HostStatus.First;
        }
    }
    ,
    preferSecondary{

        @Override
        public boolean allowConnectingTo(HostStatus hostStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return hostStatus != HostStatus.ConnectFail;
        }
    };


    public abstract boolean allowConnectingTo(HostStatus var1);

    public static HostRequirement getTargetServerType(String targetServerTypeT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String allowSlaveT = targetServerTypeT.replace("lave", "econdary");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return HostRequirement.valueOf(allowSlaveT);
    }
}

