/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.BaseStatement;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.core.TypeInfo;
import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.jdbc.TypeInfoCacheFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class TypeInfoCache
implements TypeInfo {
    private Map<String, Integer> kbNameToSQLType;
    private Map<String, String> kbNameToJavaClass;
    private Map<Integer, String> oidToKbName;
    private Map<String, Integer> kbNameToOid;
    private Map<String, Class<? extends KBobject>> kbNameToKbObject;
    private Map<Integer, Integer> kbArrayToKbType;
    private Map<Integer, Character> arrayOidToDelimiter;
    private BaseConnection baseConnection;
    protected final int unknownLength;
    private PreparedStatement getTypeWithModStatementPst;
    private PreparedStatement getTypeInfoStatement2Pst;
    private TypeInfoCacheFactory typeInfoCacheFactory;
    private PreparedStatement getTypeInfoStatementPst;
    private PreparedStatement getOidStatementSimplePst;
    private PreparedStatement getNameStatementPst;
    private PreparedStatement getArrayElementOidStatementPst;
    private PreparedStatement getArrayDelimiterStatementPst;
    private PreparedStatement getOidStatementComplexNonArrayPst;
    private PreparedStatement getOidStatementComplexArrayPst;
    static Set<Integer> caseSensitiveSet = new HashSet<Integer>();
    static Set<Integer> signedSet;
    private static Set<Integer> requiresQuotingSqlTypeSet;

    public Object[][] getTypes() {
        return this.typeInfoCacheFactory.getTypeInfoCache().getTypes();
    }

    public HashMap<String, String> getTypeAliases() {
        return this.typeInfoCacheFactory.getTypeInfoCache().getTypeAliases();
    }

    public TypeInfoCache(BaseConnection _conn, int unknownLength) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.baseConnection = _conn;
        this.typeInfoCacheFactory = new TypeInfoCacheFactory(_conn, this);
        this.unknownLength = unknownLength;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.oidToKbName = new HashMap<Integer, String>((int)Math.round((double)this.getTypes().length * 1.5));
        this.kbNameToOid = new HashMap<String, Integer>((int)Math.round((double)this.getTypes().length * 1.5));
        this.kbNameToJavaClass = new HashMap<String, String>((int)Math.round((double)this.getTypes().length * 1.5));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbNameToKbObject = new HashMap<String, Class<? extends KBobject>>((int)Math.round((double)this.getTypes().length * 1.5));
        this.kbArrayToKbType = new HashMap<Integer, Integer>((int)Math.round((double)this.getTypes().length * 1.5));
        this.arrayOidToDelimiter = new HashMap<Integer, Character>((int)Math.round((double)this.getTypes().length * 2.5));
        this.kbNameToSQLType = Collections.synchronizedMap(new HashMap((int)Math.round((double)this.getTypes().length * 1.5)));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (Object[] type : this.getTypes()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String kbTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer _sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(kbTypeName, oid, _sqlType, javaClass, arrayOid);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbNameToJavaClass.put("hstore", Map.class.getName());
    }

    @Override
    public synchronized void addCoreType(String kbTypeName, Integer oid, Integer _sqlType, String javaClass, Integer arrayOid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbNameToJavaClass.put(kbTypeName, javaClass);
        this.kbNameToOid.put(kbTypeName, oid);
        this.oidToKbName.put(oid, kbTypeName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbArrayToKbType.put(arrayOid, oid);
        this.kbNameToSQLType.put(kbTypeName, _sqlType);
        Character delimiter = Character.valueOf(',');
        this.arrayOidToDelimiter.put(oid, delimiter);
        this.arrayOidToDelimiter.put(arrayOid, delimiter);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String kbArrayTypeName = kbTypeName + "[]";
        this.kbNameToJavaClass.put(kbArrayTypeName, "java.sql.Array");
        this.kbNameToSQLType.put(kbArrayTypeName, 2003);
        this.kbNameToOid.put(kbArrayTypeName, arrayOid);
        kbArrayTypeName = "_" + kbTypeName;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.kbNameToJavaClass.containsKey(kbArrayTypeName)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbNameToJavaClass.put(kbArrayTypeName, "java.sql.Array");
            this.kbNameToSQLType.put(kbArrayTypeName, 2003);
            this.kbNameToOid.put(kbArrayTypeName, arrayOid);
            this.oidToKbName.put(arrayOid, kbArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends KBobject> klass) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbNameToKbObject.put(type, klass);
        this.kbNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getKBTypeNamesWithSQLTypes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.kbNameToSQLType.keySet().iterator();
    }

    @Override
    public int getSQLType(Object _param) throws SQLException {
        ResultSet resultSet;
        String kbTypeName;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int oid = 0;
        if (_param instanceof Integer) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oid = (Integer)_param;
            kbTypeName = this.getKBType(oid);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            kbTypeName = (String)_param;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (kbTypeName.endsWith("[]")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 2003;
        }
        Integer i = this.kbNameToSQLType.get(kbTypeName);
        if (i != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return i;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String preArrayStr = "[";
        String sufArrayStr = "]";
        if (CompatibleDB.sqlserver(this.baseConnection.getCompatibleLevel())) {
            preArrayStr = "{";
            sufArrayStr = "}";
        }
        String _sql = "SELECT pt.typinput='array_in'::regproc, pt.typtype   FROM PG_CATALOG.PG_type pt  LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))" + preArrayStr + "s.r" + sufArrayStr + " as nspname       from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_param instanceof Integer) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.getTypeInfoStatement2Pst == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql = _sql + " WHERE pt.oid = ?  ORDER BY sp.r, pt.oid DESC LIMIT 1;";
                this.getTypeInfoStatement2Pst = this.baseConnection.prepareStatement(_sql);
            }
            this.getTypeInfoStatement2Pst.setInt(1, oid);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!((BaseStatement)((Object)this.getTypeInfoStatement2Pst)).executeWithFlags(16)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet = this.getTypeInfoStatement2Pst.getResultSet();
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.getTypeInfoStatementPst == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql = _sql + " WHERE pt.typname = ?  ORDER BY sp.r, pt.oid DESC LIMIT 1;";
                this.getTypeInfoStatementPst = this.baseConnection.prepareStatement(_sql);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.getTypeInfoStatementPst.setString(1, kbTypeName);
            if (!((BaseStatement)((Object)this.getTypeInfoStatementPst)).executeWithFlags(16)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet = this.getTypeInfoStatementPst.getResultSet();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Integer typeT = null;
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean isArrayT = resultSet.getBoolean(1);
            String typtype = resultSet.getString(2);
            if (isArrayT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                typeT = 2003;
            } else if ("c".equals(typtype)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                typeT = 2002;
            } else if ("d".equals(typtype)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                typeT = 2001;
            } else if ("e".equals(typtype)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                typeT = 12;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (typeT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            typeT = 1111;
        }
        resultSet.close();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbNameToSQLType.put(kbTypeName, typeT);
        return typeT;
    }

    @Override
    public int getFastSQLType(Object param, String typType, boolean isArray) throws SQLException {
        String pgTypeName;
        int oid = 0;
        if (param instanceof Integer) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oid = (Integer)param;
            pgTypeName = this.getKBType(oid);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            pgTypeName = (String)param;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (pgTypeName.endsWith("[]")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 2003;
        }
        Integer i = this.kbNameToSQLType.get(pgTypeName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (i != null) {
            return i;
        }
        Integer type = 1111;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (isArray) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            type = 2003;
        } else if ("c".equals(typType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            type = 2002;
        } else if ("d".equals(typType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            type = 2001;
        } else if ("e".equals(typType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            type = 12;
        }
        return type;
    }

    private PreparedStatement getOidStatement(String kbTypeName) throws SQLException {
        String nameT;
        String schemaNameT;
        String fullNameT;
        PreparedStatement oidStatementComplexPst;
        String _sql;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean isArray = kbTypeName.endsWith("[]");
        boolean hasQuote = kbTypeName.contains("\"");
        int dotIndexT = kbTypeName.indexOf(46);
        String preArrayStr = "[";
        String sufArrayStr = "]";
        if (CompatibleDB.sqlserver(this.baseConnection.getCompatibleLevel())) {
            preArrayStr = "{";
            sufArrayStr = "}";
        }
        if (dotIndexT == -1 && !hasQuote && !isArray) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.getOidStatementSimplePst == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String _sql2 = "SELECT pg_type.oid, typname   FROM PG_CATALOG.PG_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))" + preArrayStr + "s.r" + sufArrayStr + " as nspname               from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r nulls last, pg_type.oid DESC LIMIT 1;";
                this.getOidStatementSimplePst = this.baseConnection.prepareStatement(_sql2);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String lcName = kbTypeName.toLowerCase();
            this.getOidStatementSimplePst.setString(1, lcName);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getOidStatementSimplePst;
        }
        if (isArray) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.getOidStatementComplexArrayPst == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.baseConnection.haveMinimumServerVersion(ServerVersion.v8_3)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sql = "SELECT t.typarray, arra.typname   FROM PG_CATALOG.PG_type t  JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid  JOIN PG_CATALOG.PG_type arra ON arra.oid = t.typarray WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sql = "SELECT t.oid, t.typname   FROM PG_CATALOG.PG_type t  JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid WHERE t.typelem = (SELECT oid FROM PG_CATALOG.PG_type WHERE typname = ?) AND substring(t.typname, 1, 1) = '_' AND t.typlen = -1 AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.typelem DESC LIMIT 1";
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.getOidStatementComplexArrayPst = this.baseConnection.prepareStatement(_sql);
            }
            oidStatementComplexPst = this.getOidStatementComplexArrayPst;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (null == this.getOidStatementComplexNonArrayPst) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql = "SELECT t.oid, t.typname   FROM PG_CATALOG.PG_type t  JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                this.getOidStatementComplexNonArrayPst = this.baseConnection.prepareStatement(_sql);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oidStatementComplexPst = this.getOidStatementComplexNonArrayPst;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String string = fullNameT = isArray ? kbTypeName.substring(0, kbTypeName.length() - 2) : kbTypeName;
        if (dotIndexT == -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            schemaNameT = null;
            nameT = fullNameT;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (fullNameT.startsWith("\"")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (fullNameT.endsWith("\"")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String[] parts = fullNameT.split("\"\\.\"");
                    schemaNameT = parts.length == 2 ? parts[0] + "\"" : null;
                    nameT = parts.length == 2 ? "\"" + parts[1] : parts[0];
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int lastDotIndex = fullNameT.lastIndexOf(46);
                    nameT = fullNameT.substring(lastDotIndex + 1);
                    schemaNameT = fullNameT.substring(0, lastDotIndex);
                }
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                schemaNameT = fullNameT.substring(0, dotIndexT);
                nameT = fullNameT.substring(dotIndexT + 1);
            }
        }
        if (schemaNameT != null && schemaNameT.startsWith("\"") && schemaNameT.endsWith("\"")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            schemaNameT = schemaNameT.substring(1, schemaNameT.length() - 1);
        } else if (schemaNameT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            schemaNameT = schemaNameT.toLowerCase();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (nameT.startsWith("\"") && nameT.endsWith("\"")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nameT = nameT.substring(1, nameT.length() - 1);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nameT = nameT.toLowerCase();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidStatementComplexPst.setString(1, nameT);
        oidStatementComplexPst.setString(2, schemaNameT);
        oidStatementComplexPst.setBoolean(3, schemaNameT == null);
        return oidStatementComplexPst;
    }

    @Override
    public synchronized int getKBType(String kbTypeName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Integer oid = this.kbNameToOid.get(kbTypeName);
        if (oid != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(kbTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oid = 0;
        ResultSet resultSet = oidStatement.getResultSet();
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oid = (int)resultSet.getLong(1);
            String internalName = resultSet.getString(2);
            this.oidToKbName.put(oid, internalName);
            this.kbNameToOid.put(internalName, oid);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbNameToOid.put(kbTypeName, oid);
        resultSet.close();
        return oid;
    }

    @Override
    public synchronized String getKBType(int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        String kbTypeName = this.oidToKbName.get(oid);
        if (kbTypeName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return kbTypeName;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getNameStatementPst == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM PG_CATALOG.PG_type t JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getNameStatementPst = this.baseConnection.prepareStatement(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.getNameStatementPst.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getNameStatementPst)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = this.getNameStatementPst.getResultSet();
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean onPath = resultSet.getBoolean(1);
            String schemaName = resultSet.getString(2);
            String name = resultSet.getString(3);
            if (onPath) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                kbTypeName = name;
                this.kbNameToOid.put(schemaName + "." + name, oid);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                kbTypeName = "\"" + schemaName + "\".\"" + name + "\"";
                if (schemaName.equals(schemaName.toLowerCase()) && schemaName.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbNameToOid.put(schemaName + "." + name, oid);
                }
            }
            this.kbNameToOid.put(kbTypeName, oid);
            this.oidToKbName.put(oid, kbTypeName);
        }
        resultSet.close();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return kbTypeName;
    }

    @Override
    public synchronized String getKBTypeWithMod(int oid, int mod) throws SQLException {
        int position;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        String kbTypeNameWithMod = new String();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getTypeWithModStatementPst == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "select pg_catalog.format_type(?,?)";
            this.getTypeWithModStatementPst = this.baseConnection.prepareStatement(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.getTypeWithModStatementPst.setInt(1, oid);
        this.getTypeWithModStatementPst.setInt(2, mod);
        if (!((BaseStatement)((Object)this.getTypeWithModStatementPst)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = this.getTypeWithModStatementPst.getResultSet();
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            kbTypeNameWithMod = resultSet.getString(1);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        resultSet.close();
        if (oid != 7002 && oid != 7000 && (position = kbTypeNameWithMod.indexOf(40)) != -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            kbTypeNameWithMod = kbTypeNameWithMod.substring(0, position);
        }
        return kbTypeNameWithMod;
    }

    @Override
    public int getKBArrayType(String elementTypeNameT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        elementTypeNameT = this.getTypeForAlias(elementTypeNameT);
        return this.getKBType(elementTypeNameT + "[]");
    }

    protected synchronized int convertArrayToBaseOid(int oidT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Integer iT = this.kbArrayToKbType.get(oidT);
        if (iT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return oidT;
        }
        return iT;
    }

    @Override
    public synchronized char getArrayDelimiter(int oidT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oidT == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ',';
        }
        Character delimiter = this.arrayOidToDelimiter.get(oidT);
        if (delimiter != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return delimiter.charValue();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getArrayDelimiterStatementPst == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "SELECT e.typdelim FROM PG_CATALOG.PG_type t, PG_CATALOG.PG_type e WHERE t.oid = ? and t.typelem = e.oid";
            this.getArrayDelimiterStatementPst = this.baseConnection.prepareStatement(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.getArrayDelimiterStatementPst.setInt(1, oidT);
        if (!((BaseStatement)((Object)this.getArrayDelimiterStatementPst)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = this.getArrayDelimiterStatementPst.getResultSet();
        if (!resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = resultSet.getString(1);
        delimiter = Character.valueOf(s.charAt(0));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.arrayOidToDelimiter.put(oidT, delimiter);
        resultSet.close();
        return delimiter.charValue();
    }

    @Override
    public synchronized int getKBArrayElement(int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        Integer kbType = this.kbArrayToKbType.get(oid);
        if (kbType != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return kbType;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getArrayElementOidStatementPst == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname FROM PG_CATALOG.PG_type t JOIN PG_CATALOG.PG_type e ON t.typelem = e.oid JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getArrayElementOidStatementPst = this.baseConnection.prepareStatement(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.getArrayElementOidStatementPst.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getArrayElementOidStatementPst)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = this.getArrayElementOidStatementPst.getResultSet();
        if (!resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        kbType = (int)resultSet.getLong(1);
        boolean onPath = resultSet.getBoolean(2);
        String schemaName = resultSet.getString(3);
        String name = resultSet.getString(4);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbArrayToKbType.put(oid, kbType);
        this.kbNameToOid.put(schemaName + "." + name, kbType);
        String fullName = "\"" + schemaName + "\".\"" + name + "\"";
        this.kbNameToOid.put(fullName, kbType);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (onPath && name.equals(name.toLowerCase())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.oidToKbName.put(kbType, name);
            this.kbNameToOid.put(name, kbType);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.oidToKbName.put(kbType, fullName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        resultSet.close();
        return kbType;
    }

    @Override
    public synchronized Class<? extends KBobject> getKBobject(String type) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.kbNameToKbObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String kbTypeName = this.getKBType(oid);
        String _result = this.kbNameToJavaClass.get(kbTypeName);
        if (_result != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _result;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getSQLType(kbTypeName) == 2003) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _result = "java.sql.Array";
            this.kbNameToJavaClass.put(kbTypeName, _result);
        }
        return _result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String type = this.getTypeAliases().get(alias);
        if (type != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return type;
        }
        if (alias.indexOf(34) == -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            type = this.getTypeAliases().get(alias.toLowerCase());
            if (type != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return type;
            }
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typemod) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCacheFactory.getTypeInfoCache().getPrecision(oid, typemod, this.baseConnection);
    }

    @Override
    public int getColumnSize(int oid, int typemod) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCacheFactory.getTypeInfoCache().getColumnSize(oid, typemod, this.baseConnection);
    }

    @Override
    public int getScale(int oid, int typemod) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCacheFactory.getTypeInfoCache().getScale(oid, typemod, this.baseConnection);
    }

    @Override
    public boolean isCaseSensitive(int oidT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidT = this.convertArrayToBaseOid(oidT);
        if (caseSensitiveSet.contains(oidT)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean isSigned(int oid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int baseOid = this.convertArrayToBaseOid(oid);
        if (signedSet.contains(baseOid)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public int getDisplaySize(int oid, int typemod) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCacheFactory.getTypeInfoCache().getDisplaySize(oid, typemod, this.baseConnection);
    }

    @Override
    public int getMaximumPrecision(int oidT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidT = this.convertArrayToBaseOid(oidT);
        if (oidT == 1700) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 1000;
        }
        if (oidT == 1266 || oidT == 1083 || oidT == 7950) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 6;
        }
        if (oidT == 1186 || oidT == 1114 || oidT == 1184 || oidT == 7952 || oidT == 7954) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 6;
        }
        if (oidT == 1043 || oidT == 1042 || oidT == 8018 || oidT == 8016) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0xA00000;
        }
        if (oidT == 1562 || oidT == 1560) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0x5000000;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(_sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int _sqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (requiresQuotingSqlTypeSet.contains(_sqlType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        caseSensitiveSet.add(8100);
        caseSensitiveSet.add(26);
        caseSensitiveSet.add(21);
        caseSensitiveSet.add(7014);
        caseSensitiveSet.add(7016);
        caseSensitiveSet.add(7015);
        caseSensitiveSet.add(7082);
        caseSensitiveSet.add(7084);
        caseSensitiveSet.add(20);
        caseSensitiveSet.add(23);
        caseSensitiveSet.add(701);
        caseSensitiveSet.add(700);
        caseSensitiveSet.add(16);
        caseSensitiveSet.add(1700);
        caseSensitiveSet.add(1562);
        caseSensitiveSet.add(1560);
        caseSensitiveSet.add(4655);
        caseSensitiveSet.add(8020);
        caseSensitiveSet.add(1082);
        caseSensitiveSet.add(1114);
        caseSensitiveSet.add(1083);
        caseSensitiveSet.add(1266);
        caseSensitiveSet.add(7950);
        caseSensitiveSet.add(7944);
        caseSensitiveSet.add(7952);
        caseSensitiveSet.add(7954);
        caseSensitiveSet.add(1186);
        caseSensitiveSet.add(1184);
        caseSensitiveSet.add(7000);
        caseSensitiveSet.add(7002);
        signedSet = new HashSet<Integer>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        signedSet.add(7014);
        signedSet.add(8100);
        signedSet.add(7015);
        signedSet.add(21);
        signedSet.add(23);
        signedSet.add(7016);
        signedSet.add(700);
        signedSet.add(20);
        signedSet.add(1700);
        signedSet.add(701);
        signedSet.add(7000);
        signedSet.add(7002);
        signedSet.add(5026);
        requiresQuotingSqlTypeSet = new HashSet<Integer>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        requiresQuotingSqlTypeSet.add(8);
        requiresQuotingSqlTypeSet.add(-5);
        requiresQuotingSqlTypeSet.add(4);
        requiresQuotingSqlTypeSet.add(6);
        requiresQuotingSqlTypeSet.add(5);
        requiresQuotingSqlTypeSet.add(7);
        requiresQuotingSqlTypeSet.add(2);
        requiresQuotingSqlTypeSet.add(-6);
        requiresQuotingSqlTypeSet.add(-7);
        requiresQuotingSqlTypeSet.add(3);
    }
}

