/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ukpwd;

import com.kingbase8.KBProperty;
import com.kingbase8.core.KBStream;
import com.kingbase8.ssl.LazyKeyManager;
import com.kingbase8.ssl.LibKCIFactory;
import com.kingbase8.ssl.PKCS12KeyManager;
import com.kingbase8.ukpwd.SM2Sign;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.ObjectFactory;
import com.kingbase8.util.TraceLogger;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.security.auth.callback.CallbackHandler;

public class CertAuthenticator {
    private Properties infoProps;
    private KBStream kbStream;
    private byte[] clientRandom;
    private KeyManager km;
    private boolean defaultfileT;
    private String sslrootcertfile;
    private String sslcertfile;
    private String sslkeyfileT;

    public CertAuthenticator(KBStream kbStream, Properties infoProps) throws KSQLException {
        String defaultdirT;
        this.kbStream = kbStream;
        this.infoProps = infoProps;
        String pathsepT = System.getProperty("file.separator");
        String windosStr = "windows";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (System.getProperty("os.name").toLowerCase().contains(windosStr)) {
            defaultdirT = System.getenv("APPDATA") + pathsepT + "kingbase8" + pathsepT;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            defaultdirT = System.getProperty("user.home") + pathsepT + ".kingbase8" + pathsepT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sslkeyfileT = KBProperty.UKPWD_KEY.get(infoProps);
        if (this.sslkeyfileT == null) {
            this.defaultfileT = true;
            this.sslkeyfileT = defaultdirT + "uclient.pk8";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.sslkeyfileT.endsWith("pk8") || this.sslkeyfileT.endsWith("key")) {
            this.initPk8(this.sslkeyfileT, defaultdirT, infoProps);
        } else if (this.sslkeyfileT.endsWith("p12")) {
            this.initP12(this.sslkeyfileT, infoProps);
        } else {
            throw new KSQLException("The key file must end with pk8 or p12 or key.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sslrootcertfile = KBProperty.UKPWD_ROOT_CERT.get(infoProps);
        if (this.sslrootcertfile == null) {
            this.sslrootcertfile = defaultdirT + "ca.crt";
        }
    }

    private void initPk8(String sslkeyfile, String defaultdir, Properties info) throws KSQLException {
        this.sslcertfile = KBProperty.UKPWD_CERT.get(info);
        if (this.sslcertfile == null) {
            this.defaultfileT = true;
            this.sslcertfile = defaultdir + "uclient.crt";
        }
        this.km = new LazyKeyManager("".equals(this.sslcertfile) ? null : this.sslcertfile, "".equals(sslkeyfile) ? null : sslkeyfile, this.getCallbackHandler(info), this.defaultfileT);
    }

    private void initP12(String sslkeyfile, Properties info) throws KSQLException {
        this.km = new PKCS12KeyManager(sslkeyfile, this.getCallbackHandler(info));
    }

    private CallbackHandler getCallbackHandler(Properties info) throws KSQLException {
        CallbackHandler cbh;
        String sslpasswordcallback = KBProperty.UKPWD_PASSWORD_CALLBACK.get(info);
        if (sslpasswordcallback != null) {
            try {
                cbh = ObjectFactory.instantiate(CallbackHandler.class, sslpasswordcallback, info, false, null);
            }
            catch (Exception e) {
                throw new KSQLException(GT.tr("The password callback class provided {0} could not be instantiated.", sslpasswordcallback), KSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        } else {
            cbh = new LibKCIFactory.ConsoleCallbackHandler(KBProperty.UKPWD_PASSWORD.get(info));
        }
        return cbh;
    }

    public void sendCertAndSign(int len) throws IOException, SQLException {
        String randomNumber = this.kbStream.receiveString(len - 1);
        int certType = this.kbStream.receiveChar();
        if (certType == 50) {
            try {
                KBLOGGER.log(Level.FINEST, "class load.... " + CertAuthenticator.class.getClassLoader().toString(), new Object[0]);
                Security.insertProviderAt((Provider)Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance(), 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new KSQLException(GT.tr(e.getMessage(), new Object[0]), KSQLState.CONNECTION_REJECTED);
            }
        }
        Random random = new Random();
        char[] clientRand = new char[]{(char)(random.nextInt(100) + 1), (char)(random.nextInt(100) + 1), (char)(random.nextInt(100) + 1), (char)(random.nextInt(100) + 1)};
        this.clientRandom = new String(clientRand).getBytes();
        X509Certificate[] cert = null;
        PrivateKey key = null;
        if (this.km instanceof LazyKeyManager) {
            String aliasT = null;
            if (certType == 50) {
                aliasT = "BC";
                cert = ((LazyKeyManager)this.km).getCertificateChain(aliasT);
            } else {
                if (this.sslkeyfileT.endsWith("key")) {
                    throw new KSQLException("The key file must end with pk8 or p12.", KSQLState.INVALID_PARAMETER_VALUE);
                }
                cert = ((LazyKeyManager)this.km).getCertificateChain(aliasT);
                key = ((LazyKeyManager)this.km).getPrivateKey(aliasT);
            }
            ((LazyKeyManager)this.km).throwKeyManagerException();
        } else if (this.km instanceof PKCS12KeyManager) {
            cert = ((PKCS12KeyManager)this.km).getCertificateChain(null);
            key = ((PKCS12KeyManager)this.km).getPrivateKey(null);
            ((PKCS12KeyManager)this.km).throwKeyManagerException();
        }
        byte[] signdigest = null;
        try {
            if (certType == 50) {
                if (this.sslcertfile == null) {
                    throw new KSQLException("ukpwdcert is not allowed to be null.", KSQLState.INVALID_PARAMETER_VALUE);
                }
                signdigest = SM2Sign.getSigndigest(this.sslcertfile, this.sslkeyfileT, randomNumber, KBProperty.USER.get(this.infoProps));
            } else {
                Signature sign = Signature.getInstance("SHA1WithRSA");
                sign.initSign(key);
                sign.update(randomNumber.getBytes());
                signdigest = sign.sign();
            }
        }
        catch (Exception e) {
            throw new KSQLException("Could not sign server number.", KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        byte[] usercert = null;
        try {
            if (cert == null) {
                throw new KSQLException("X509Certificate is null", KSQLState.CONNECTION_FAILURE);
            }
            usercert = cert[0].getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new KSQLException("Could not transform uclient certificate file", KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        this.kbStream.sendChar(99);
        this.kbStream.sendInteger4(16 + signdigest.length + usercert.length);
        this.kbStream.send(this.clientRandom);
        this.kbStream.sendInteger42(signdigest.length);
        this.kbStream.sendInteger42(usercert.length);
        this.kbStream.send(signdigest);
        this.kbStream.send(usercert);
        this.kbStream.flush();
    }

    public void verifyServerSign() throws SQLException, IOException {
        X509Certificate[] sercert;
        X509Certificate[] rootcert;
        int serversignlen = this.kbStream.receiveInteger42();
        int servercertlen = this.kbStream.receiveInteger42();
        byte[] serversign = this.kbStream.receive(serversignlen);
        byte[] servercert = this.kbStream.receive(servercertlen);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            FileInputStream fin = new FileInputStream(this.sslrootcertfile);
            Collection<? extends Certificate> rootcerts = cf.generateCertificates(fin);
            rootcert = rootcerts.toArray(new X509Certificate[0]);
            ByteArrayInputStream bin = new ByteArrayInputStream(servercert);
            Collection<? extends Certificate> sercertcerts = cf.generateCertificates(bin);
            sercert = sercertcerts.toArray(new X509Certificate[0]);
        }
        catch (IOException ioex) {
            throw new KSQLException(GT.tr("Could not read root certificate file {0}.", this.sslrootcertfile), KSQLState.CONNECTION_FAILURE, (Throwable)ioex);
        }
        catch (CertificateException gsex) {
            throw new KSQLException("Loading the certificate failed.", KSQLState.CONNECTION_FAILURE, (Throwable)gsex);
        }
        try {
            sercert[0].verify(rootcert[0].getPublicKey());
        }
        catch (Exception e) {
            throw new KSQLException("Verify the certificate of server failed.", KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        try {
            Signature sign = Signature.getInstance("SHA1WithRSA");
            sign.initVerify(sercert[0]);
            sign.update(this.clientRandom);
            boolean success = sign.verify(serversign);
            if (!success) {
                throw new KSQLException("Verify the signature of the server failed.", KSQLState.CONNECTION_FAILURE);
            }
        }
        catch (Exception e) {
            throw new KSQLException("Verify the signature of the server failed.", KSQLState.CONNECTION_FAILURE);
        }
    }
}

