/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheListener;
import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.CacheObjIterator;
import cn.hutool.cache.impl.CacheValuesIterator;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.lang.mutable.Mutable;
import cn.hutool.core.lang.mutable.MutableObj;
import cn.hutool.core.map.SafeConcurrentHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = 1L;
    protected Map<Mutable<K>, CacheObj<K, V>> cacheMap;
    protected final SafeConcurrentHashMap<K, Lock> keyLockMap = new SafeConcurrentHashMap();
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected LongAdder hitCount = new LongAdder();
    protected LongAdder missCount = new LongAdder();
    protected CacheListener<K, V> listener;

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    protected void putWithoutLock(K key, V object, long timeout) {
        MutableObj<K> mKey;
        CacheObj<K, V> oldObj;
        CacheObj<K, V> co = new CacheObj<K, V>(key, object, timeout);
        if (timeout != 0L) {
            this.existCustomTimeout = true;
        }
        if (null != (oldObj = this.cacheMap.get(mKey = MutableObj.of(key)))) {
            this.onRemove(oldObj.key, oldObj.obj);
            this.cacheMap.put(mKey, co);
        } else {
            if (this.isFull()) {
                this.pruneCache();
            }
            this.cacheMap.put(mKey, co);
        }
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public long getMissCount() {
        return this.missCount.sum();
    }

    @Override
    public V get(K key, boolean isUpdateLastAccess, Func0<V> supplier) {
        return this.get(key, isUpdateLastAccess, this.timeout, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess, long timeout, Func0<V> supplier) {
        Object v = this.get(key, isUpdateLastAccess);
        if (null == v && null != supplier) {
            Lock keyLock = this.keyLockMap.computeIfAbsent(key, k -> new ReentrantLock());
            keyLock.lock();
            try {
                v = this.get(key, isUpdateLastAccess);
                if (null == v) {
                    v = supplier.callWithRuntimeException();
                    this.put(key, v, timeout);
                }
            }
            finally {
                keyLock.unlock();
                this.keyLockMap.remove(key);
            }
        }
        return v;
    }

    protected CacheObj<K, V> getWithoutLock(K key) {
        return this.cacheMap.get(MutableObj.of(key));
    }

    @Override
    public Iterator<V> iterator() {
        CacheObjIterator copiedIterator = (CacheObjIterator)this.cacheObjIterator();
        return new CacheValuesIterator(copiedIterator);
    }

    protected abstract int pruneCache();

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    @Override
    public AbstractCache<K, V> setListener(CacheListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    public Set<K> keySet() {
        return this.cacheMap.keySet().stream().map(Mutable::get).collect(Collectors.toSet());
    }

    protected void onRemove(K key, V cachedObject) {
        CacheListener<K, V> listener = this.listener;
        if (null != listener) {
            listener.onRemove(key, cachedObject);
        }
    }

    protected CacheObj<K, V> removeWithoutLock(K key) {
        return this.cacheMap.remove(MutableObj.of(key));
    }

    protected Iterator<CacheObj<K, V>> cacheObjIter() {
        return this.cacheMap.values().iterator();
    }
}

