/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel;

import cn.idev.excel.analysis.ExcelAnalyser;
import cn.idev.excel.analysis.ExcelAnalyserImpl;
import cn.idev.excel.analysis.ExcelReadExecutor;
import cn.idev.excel.context.AnalysisContext;
import cn.idev.excel.read.metadata.ReadSheet;
import cn.idev.excel.read.metadata.ReadWorkbook;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ExcelReader.class);
    private final ExcelAnalyser excelAnalyser;

    public ExcelReader(ReadWorkbook readWorkbook) {
        this.excelAnalyser = new ExcelAnalyserImpl(readWorkbook);
    }

    @Deprecated
    public void read() {
        this.readAll();
    }

    public void readAll() {
        this.excelAnalyser.analysis(null, Boolean.TRUE);
    }

    public ExcelReader read(ReadSheet ... readSheet) {
        return this.read(Arrays.asList(readSheet));
    }

    public ExcelReader read(List<ReadSheet> readSheetList) {
        this.excelAnalyser.analysis(readSheetList, Boolean.FALSE);
        return this;
    }

    public AnalysisContext analysisContext() {
        return this.excelAnalyser.analysisContext();
    }

    public ExcelReadExecutor excelExecutor() {
        return this.excelAnalyser.excelExecutor();
    }

    @Deprecated
    public AnalysisContext getAnalysisContext() {
        return this.analysisContext();
    }

    public void finish() {
        if (this.excelAnalyser != null) {
            this.excelAnalyser.finish();
        }
    }

    @Override
    public void close() {
        this.finish();
    }

    protected void finalize() {
        try {
            this.finish();
        }
        catch (Throwable e) {
            log.warn("Destroy object failed", e);
        }
    }
}

