/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.analysis.v07.handlers;

import cn.idev.excel.analysis.v07.handlers.AbstractXlsxTagHandler;
import cn.idev.excel.constant.EasyExcelConstants;
import cn.idev.excel.context.xlsx.XlsxReadContext;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.metadata.data.ReadCellData;
import cn.idev.excel.read.metadata.holder.xlsx.XlsxReadSheetHolder;
import cn.idev.excel.util.BooleanUtils;
import cn.idev.excel.util.PositionUtils;
import cn.idev.excel.util.StringUtils;
import java.math.BigDecimal;
import org.xml.sax.Attributes;

public class CellTagHandler
extends AbstractXlsxTagHandler {
    private static final int DEFAULT_FORMAT_INDEX = 0;

    @Override
    public void startElement(XlsxReadContext xlsxReadContext, String name, Attributes attributes) {
        XlsxReadSheetHolder xlsxReadSheetHolder = xlsxReadContext.xlsxReadSheetHolder();
        xlsxReadSheetHolder.setColumnIndex(PositionUtils.getCol(attributes.getValue("r"), xlsxReadSheetHolder.getColumnIndex()));
        CellDataTypeEnum type = CellDataTypeEnum.buildFromCellType(attributes.getValue("t"));
        xlsxReadSheetHolder.setTempCellData(new ReadCellData(type));
        xlsxReadSheetHolder.setTempData(new StringBuilder());
        String dateFormatIndex = attributes.getValue("s");
        int dateFormatIndexInteger = StringUtils.isEmpty(dateFormatIndex) ? 0 : Integer.parseInt(dateFormatIndex);
        xlsxReadSheetHolder.getTempCellData().setDataFormatData(xlsxReadContext.xlsxReadWorkbookHolder().dataFormatData(dateFormatIndexInteger));
    }

    @Override
    public void endElement(XlsxReadContext xlsxReadContext, String name) {
        XlsxReadSheetHolder xlsxReadSheetHolder = xlsxReadContext.xlsxReadSheetHolder();
        ReadCellData<?> tempCellData = xlsxReadSheetHolder.getTempCellData();
        StringBuilder tempData = xlsxReadSheetHolder.getTempData();
        String tempDataString = tempData.toString();
        CellDataTypeEnum oldType = tempCellData.getType();
        switch (oldType) {
            case STRING: {
                if (StringUtils.isEmpty(tempDataString)) break;
                String stringValue = xlsxReadContext.readWorkbookHolder().getReadCache().get(Integer.valueOf(tempDataString));
                tempCellData.setStringValue(stringValue);
                break;
            }
            case DIRECT_STRING: 
            case ERROR: {
                tempCellData.setStringValue(tempDataString);
                tempCellData.setType(CellDataTypeEnum.STRING);
                break;
            }
            case BOOLEAN: {
                if (StringUtils.isEmpty(tempDataString)) {
                    tempCellData.setType(CellDataTypeEnum.EMPTY);
                    break;
                }
                tempCellData.setBooleanValue(BooleanUtils.valueOf(tempData.toString()));
                break;
            }
            case NUMBER: 
            case EMPTY: {
                if (StringUtils.isEmpty(tempDataString)) {
                    tempCellData.setType(CellDataTypeEnum.EMPTY);
                    break;
                }
                tempCellData.setType(CellDataTypeEnum.NUMBER);
                tempCellData.setOriginalNumberValue(new BigDecimal(tempDataString));
                tempCellData.setNumberValue(tempCellData.getOriginalNumberValue().round(EasyExcelConstants.EXCEL_MATH_CONTEXT));
                break;
            }
            default: {
                throw new IllegalStateException("Cannot set values now");
            }
        }
        if (tempCellData.getStringValue() != null && xlsxReadContext.currentReadHolder().globalConfiguration().getAutoTrim().booleanValue()) {
            tempCellData.setStringValue(tempCellData.getStringValue().trim());
        }
        tempCellData.checkEmpty();
        tempCellData.setRowIndex(xlsxReadSheetHolder.getRowIndex());
        tempCellData.setColumnIndex(xlsxReadSheetHolder.getColumnIndex());
        xlsxReadSheetHolder.getCellMap().put(xlsxReadSheetHolder.getColumnIndex(), tempCellData);
    }
}

