/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;

public class MapUtils {
    private MapUtils() {
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap(16);
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(MapUtils.capacity(expectedSize));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(MapUtils.capacity(expectedSize));
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

