/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.executor;

import cn.idev.excel.context.WriteContext;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.enums.WriteDirectionEnum;
import cn.idev.excel.enums.WriteTemplateAnalysisCellTypeEnum;
import cn.idev.excel.exception.ExcelGenerateException;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import cn.idev.excel.util.BeanMapUtils;
import cn.idev.excel.util.ClassUtils;
import cn.idev.excel.util.FieldUtils;
import cn.idev.excel.util.ListUtils;
import cn.idev.excel.util.MapUtils;
import cn.idev.excel.util.PoiUtils;
import cn.idev.excel.util.StringUtils;
import cn.idev.excel.util.WriteHandlerUtils;
import cn.idev.excel.write.executor.AbstractExcelWriteExecutor;
import cn.idev.excel.write.handler.context.CellWriteHandlerContext;
import cn.idev.excel.write.handler.context.RowWriteHandlerContext;
import cn.idev.excel.write.metadata.fill.AnalysisCell;
import cn.idev.excel.write.metadata.fill.FillConfig;
import cn.idev.excel.write.metadata.fill.FillWrapper;
import cn.idev.excel.write.metadata.holder.WriteSheetHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelWriteFillExecutor
extends AbstractExcelWriteExecutor {
    private static final String ESCAPE_FILL_PREFIX = "\\\\\\{";
    private static final String ESCAPE_FILL_SUFFIX = "\\\\\\}";
    private static final String FILL_PREFIX = "{";
    private static final String FILL_SUFFIX = "}";
    private static final char IGNORE_CHAR = '\\';
    private static final String COLLECTION_PREFIX = ".";
    private final Map<UniqueDataFlagKey, List<AnalysisCell>> templateAnalysisCache = MapUtils.newHashMap();
    private final Map<UniqueDataFlagKey, List<AnalysisCell>> templateCollectionAnalysisCache = MapUtils.newHashMap();
    private final Map<UniqueDataFlagKey, Map<AnalysisCell, CellStyle>> collectionFieldStyleCache = MapUtils.newHashMap();
    private final Map<UniqueDataFlagKey, Short> collectionRowHeightCache = MapUtils.newHashMap();
    private final Map<UniqueDataFlagKey, Map<AnalysisCell, Integer>> collectionLastIndexCache = MapUtils.newHashMap();
    private final Map<UniqueDataFlagKey, Integer> relativeRowIndexMap = MapUtils.newHashMap();
    private UniqueDataFlagKey currentUniqueDataFlag;

    public ExcelWriteFillExecutor(WriteContext writeContext) {
        super(writeContext);
    }

    public void fill(Object data, FillConfig fillConfig) {
        Object realData;
        String currentDataPrefix;
        if (data == null) {
            data = new HashMap(16);
        }
        if (fillConfig == null) {
            fillConfig = FillConfig.builder().build();
        }
        fillConfig.init();
        if (data instanceof FillWrapper) {
            FillWrapper fillWrapper = (FillWrapper)((Object)data);
            currentDataPrefix = fillWrapper.getName();
            realData = fillWrapper.getCollectionData();
        } else {
            realData = data;
            currentDataPrefix = null;
        }
        this.currentUniqueDataFlag = this.uniqueDataFlag(this.writeContext.writeSheetHolder(), currentDataPrefix);
        if (realData instanceof Collection) {
            List<AnalysisCell> analysisCellList = this.readTemplateData(this.templateCollectionAnalysisCache);
            Collection collectionData = (Collection)realData;
            if (CollectionUtils.isEmpty((Collection)collectionData)) {
                return;
            }
            Iterator iterator = collectionData.iterator();
            if (WriteDirectionEnum.VERTICAL.equals((Object)fillConfig.getDirection()) && fillConfig.getForceNewRow().booleanValue()) {
                this.shiftRows(collectionData.size(), analysisCellList);
            }
            while (iterator.hasNext()) {
                this.doFill(analysisCellList, iterator.next(), fillConfig, this.getRelativeRowIndex());
            }
        } else {
            this.doFill(this.readTemplateData(this.templateAnalysisCache), realData, fillConfig, null);
        }
    }

    private void shiftRows(int size, List<AnalysisCell> analysisCellList) {
        if (CollectionUtils.isEmpty(analysisCellList)) {
            return;
        }
        int maxRowIndex = 0;
        Map<AnalysisCell, Integer> collectionLastIndexMap = this.collectionLastIndexCache.get(this.currentUniqueDataFlag);
        for (AnalysisCell analysisCell : analysisCellList) {
            Integer lastRowIndex;
            if (collectionLastIndexMap != null && (lastRowIndex = collectionLastIndexMap.get(analysisCell)) != null) {
                if (lastRowIndex <= maxRowIndex) continue;
                maxRowIndex = lastRowIndex;
                continue;
            }
            if (analysisCell.getRowIndex() <= maxRowIndex) continue;
            maxRowIndex = analysisCell.getRowIndex();
        }
        Sheet cachedSheet = this.writeContext.writeSheetHolder().getCachedSheet();
        int lastRowIndex = cachedSheet.getLastRowNum();
        if (maxRowIndex >= lastRowIndex) {
            return;
        }
        Sheet sheet = this.writeContext.writeSheetHolder().getCachedSheet();
        int number = size;
        if (collectionLastIndexMap == null) {
            --number;
        }
        if (number <= 0) {
            return;
        }
        sheet.shiftRows(maxRowIndex + 1, lastRowIndex, number, true, false);
        this.increaseRowIndex(this.templateAnalysisCache, number, maxRowIndex);
        this.increaseRowIndex(this.templateCollectionAnalysisCache, number, maxRowIndex);
    }

    private void increaseRowIndex(Map<UniqueDataFlagKey, List<AnalysisCell>> templateAnalysisCache, int number, int maxRowIndex) {
        for (Map.Entry<UniqueDataFlagKey, List<AnalysisCell>> entry : templateAnalysisCache.entrySet()) {
            UniqueDataFlagKey uniqueDataFlagKey = entry.getKey();
            if (!Objects.equals(this.currentUniqueDataFlag.getSheetNo(), uniqueDataFlagKey.getSheetNo()) || !Objects.equals(this.currentUniqueDataFlag.getSheetName(), uniqueDataFlagKey.getSheetName())) continue;
            for (AnalysisCell analysisCell : entry.getValue()) {
                if (analysisCell.getRowIndex() <= maxRowIndex) continue;
                analysisCell.setRowIndex(analysisCell.getRowIndex() + number);
            }
        }
    }

    private void doFill(List<AnalysisCell> analysisCellList, Object oneRowData, FillConfig fillConfig, Integer relativeRowIndex) {
        if (CollectionUtils.isEmpty(analysisCellList) || oneRowData == null) {
            return;
        }
        Map dataMap = oneRowData instanceof Map ? (Map)oneRowData : BeanMapUtils.create(oneRowData);
        HashSet dataKeySet = new HashSet(dataMap.keySet());
        RowWriteHandlerContext rowWriteHandlerContext = WriteHandlerUtils.createRowWriteHandlerContext(this.writeContext, null, relativeRowIndex, Boolean.FALSE);
        for (AnalysisCell analysisCell : analysisCellList) {
            CellWriteHandlerContext cellWriteHandlerContext = WriteHandlerUtils.createCellWriteHandlerContext(this.writeContext, null, analysisCell.getRowIndex(), null, analysisCell.getColumnIndex(), relativeRowIndex, Boolean.FALSE, ExcelContentProperty.EMPTY);
            if (analysisCell.getOnlyOneVariable().booleanValue()) {
                String variable = analysisCell.getVariableList().get(0);
                Object value = null;
                if (dataKeySet.contains(variable)) {
                    value = dataMap.get(variable);
                }
                ExcelContentProperty excelContentProperty = ClassUtils.declaredExcelContentProperty(dataMap, this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadClazz(), variable, this.writeContext.currentWriteHolder());
                cellWriteHandlerContext.setExcelContentProperty(excelContentProperty);
                this.createCell(analysisCell, fillConfig, cellWriteHandlerContext, rowWriteHandlerContext);
                cellWriteHandlerContext.setOriginalValue(value);
                cellWriteHandlerContext.setOriginalFieldClass(FieldUtils.getFieldClass(dataMap, variable, value));
                this.converterAndSet(cellWriteHandlerContext);
                WriteCellData<?> cellData = cellWriteHandlerContext.getFirstCellData();
                if (fillConfig.getAutoStyle().booleanValue()) {
                    Optional.ofNullable(this.collectionFieldStyleCache.get(this.currentUniqueDataFlag)).map(collectionFieldStyleMap -> (CellStyle)collectionFieldStyleMap.get(analysisCell)).ifPresent(cellData::setOriginCellStyle);
                }
            } else {
                StringBuilder cellValueBuild = new StringBuilder();
                int index = 0;
                ArrayList cellDataList = new ArrayList();
                cellWriteHandlerContext.setExcelContentProperty(ExcelContentProperty.EMPTY);
                cellWriteHandlerContext.setIgnoreFillStyle(Boolean.TRUE);
                this.createCell(analysisCell, fillConfig, cellWriteHandlerContext, rowWriteHandlerContext);
                Cell cell = cellWriteHandlerContext.getCell();
                for (String variable : analysisCell.getVariableList()) {
                    cellValueBuild.append(analysisCell.getPrepareDataList().get(index++));
                    Object value = null;
                    if (dataKeySet.contains(variable)) {
                        value = dataMap.get(variable);
                    }
                    ExcelContentProperty excelContentProperty = ClassUtils.declaredExcelContentProperty(dataMap, this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadClazz(), variable, this.writeContext.currentWriteHolder());
                    cellWriteHandlerContext.setOriginalValue(value);
                    cellWriteHandlerContext.setOriginalFieldClass(FieldUtils.getFieldClass(dataMap, variable, value));
                    cellWriteHandlerContext.setExcelContentProperty(excelContentProperty);
                    cellWriteHandlerContext.setTargetCellDataType(CellDataTypeEnum.STRING);
                    WriteCellData<?> cellData = this.convert(cellWriteHandlerContext);
                    cellDataList.add(cellData);
                    CellDataTypeEnum type = cellData.getType();
                    if (type == null) continue;
                    switch (type) {
                        case STRING: {
                            cellValueBuild.append(cellData.getStringValue());
                            break;
                        }
                        case BOOLEAN: {
                            cellValueBuild.append(cellData.getBooleanValue());
                            break;
                        }
                        case NUMBER: {
                            cellValueBuild.append(cellData.getNumberValue());
                            break;
                        }
                    }
                }
                cellValueBuild.append(analysisCell.getPrepareDataList().get(index));
                cell.setCellValue(cellValueBuild.toString());
                cellWriteHandlerContext.setCellDataList(cellDataList);
                if (CollectionUtils.isNotEmpty(cellDataList)) {
                    cellWriteHandlerContext.setFirstCellData((WriteCellData)cellDataList.get(0));
                }
                if (fillConfig.getAutoStyle().booleanValue()) {
                    Optional.ofNullable(this.collectionFieldStyleCache.get(this.currentUniqueDataFlag)).map(collectionFieldStyleMap -> (CellStyle)collectionFieldStyleMap.get(analysisCell)).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
                }
            }
            WriteHandlerUtils.afterCellDispose(cellWriteHandlerContext);
        }
        if (rowWriteHandlerContext.getRow() != null) {
            WriteHandlerUtils.afterRowDispose(rowWriteHandlerContext);
        }
    }

    private Integer getRelativeRowIndex() {
        Integer relativeRowIndex = this.relativeRowIndexMap.get(this.currentUniqueDataFlag);
        if (relativeRowIndex == null) {
            relativeRowIndex = 0;
        } else {
            Integer n = relativeRowIndex;
            Integer n2 = relativeRowIndex = Integer.valueOf(relativeRowIndex + 1);
        }
        this.relativeRowIndexMap.put(this.currentUniqueDataFlag, relativeRowIndex);
        return relativeRowIndex;
    }

    private void createCell(AnalysisCell analysisCell, FillConfig fillConfig, CellWriteHandlerContext cellWriteHandlerContext, RowWriteHandlerContext rowWriteHandlerContext) {
        Integer lastColumnIndex;
        Integer lastRowIndex;
        Sheet cachedSheet = this.writeContext.writeSheetHolder().getCachedSheet();
        if (WriteTemplateAnalysisCellTypeEnum.COMMON.equals((Object)analysisCell.getCellType())) {
            Row row = cachedSheet.getRow(analysisCell.getRowIndex());
            cellWriteHandlerContext.setRow(row);
            Cell cell = row.getCell(analysisCell.getColumnIndex());
            cellWriteHandlerContext.setCell(cell);
            rowWriteHandlerContext.setRow(row);
            rowWriteHandlerContext.setRowIndex(analysisCell.getRowIndex());
            return;
        }
        Sheet sheet = this.writeContext.writeSheetHolder().getSheet();
        Map collectionLastIndexMap = this.collectionLastIndexCache.computeIfAbsent(this.currentUniqueDataFlag, key -> MapUtils.newHashMap());
        boolean isOriginalCell = false;
        switch (fillConfig.getDirection()) {
            case VERTICAL: {
                lastRowIndex = (Integer)collectionLastIndexMap.get(analysisCell);
                if (lastRowIndex == null) {
                    lastRowIndex = analysisCell.getRowIndex();
                    collectionLastIndexMap.put(analysisCell, lastRowIndex);
                    isOriginalCell = true;
                } else {
                    lastRowIndex = lastRowIndex + 1;
                    collectionLastIndexMap.put(analysisCell, lastRowIndex);
                }
                lastColumnIndex = analysisCell.getColumnIndex();
                break;
            }
            case HORIZONTAL: {
                lastRowIndex = analysisCell.getRowIndex();
                lastColumnIndex = (Integer)collectionLastIndexMap.get(analysisCell);
                if (lastColumnIndex == null) {
                    lastColumnIndex = analysisCell.getColumnIndex();
                    collectionLastIndexMap.put(analysisCell, lastColumnIndex);
                    isOriginalCell = true;
                    break;
                }
                lastColumnIndex = lastColumnIndex + 1;
                collectionLastIndexMap.put(analysisCell, lastColumnIndex);
                break;
            }
            default: {
                throw new ExcelGenerateException("The wrong direction.");
            }
        }
        Row row = this.createRowIfNecessary(sheet, cachedSheet, lastRowIndex, fillConfig, analysisCell, isOriginalCell, rowWriteHandlerContext);
        cellWriteHandlerContext.setRow(row);
        cellWriteHandlerContext.setRowIndex(lastRowIndex);
        cellWriteHandlerContext.setColumnIndex(lastColumnIndex);
        Cell cell = this.createCellIfNecessary(row, lastColumnIndex, cellWriteHandlerContext);
        cellWriteHandlerContext.setCell(cell);
        if (isOriginalCell) {
            Map collectionFieldStyleMap = this.collectionFieldStyleCache.computeIfAbsent(this.currentUniqueDataFlag, key -> MapUtils.newHashMap());
            collectionFieldStyleMap.put(analysisCell, cell.getCellStyle());
        }
    }

    private Cell createCellIfNecessary(Row row, Integer lastColumnIndex, CellWriteHandlerContext cellWriteHandlerContext) {
        Cell cell = row.getCell(lastColumnIndex.intValue());
        if (cell != null) {
            return cell;
        }
        WriteHandlerUtils.beforeCellCreate(cellWriteHandlerContext);
        cell = row.createCell(lastColumnIndex.intValue());
        cellWriteHandlerContext.setCell(cell);
        WriteHandlerUtils.afterCellCreate(cellWriteHandlerContext);
        return cell;
    }

    private Row createRowIfNecessary(Sheet sheet, Sheet cachedSheet, Integer lastRowIndex, FillConfig fillConfig, AnalysisCell analysisCell, boolean isOriginalCell, RowWriteHandlerContext rowWriteHandlerContext) {
        rowWriteHandlerContext.setRowIndex(lastRowIndex);
        Row row = sheet.getRow(lastRowIndex.intValue());
        if (row != null) {
            this.checkRowHeight(analysisCell, fillConfig, isOriginalCell, row);
            rowWriteHandlerContext.setRow(row);
            return row;
        }
        row = cachedSheet.getRow(lastRowIndex.intValue());
        if (row == null) {
            rowWriteHandlerContext.setRowIndex(lastRowIndex);
            WriteHandlerUtils.beforeRowCreate(rowWriteHandlerContext);
            if (fillConfig.getForceNewRow().booleanValue()) {
                row = cachedSheet.createRow(lastRowIndex.intValue());
            } else {
                try {
                    row = sheet.createRow(lastRowIndex.intValue());
                }
                catch (IllegalArgumentException ignore) {
                    row = cachedSheet.createRow(lastRowIndex.intValue());
                }
            }
            rowWriteHandlerContext.setRow(row);
            this.checkRowHeight(analysisCell, fillConfig, isOriginalCell, row);
            WriteHandlerUtils.afterRowCreate(rowWriteHandlerContext);
        } else {
            this.checkRowHeight(analysisCell, fillConfig, isOriginalCell, row);
            rowWriteHandlerContext.setRow(row);
        }
        return row;
    }

    private void checkRowHeight(AnalysisCell analysisCell, FillConfig fillConfig, boolean isOriginalCell, Row row) {
        Short rowHeight;
        if (!analysisCell.getFirstRow().booleanValue() || !WriteDirectionEnum.VERTICAL.equals((Object)fillConfig.getDirection())) {
            return;
        }
        if (isOriginalCell && PoiUtils.customHeight(row)) {
            this.collectionRowHeightCache.put(this.currentUniqueDataFlag, row.getHeight());
            return;
        }
        if (fillConfig.getAutoStyle().booleanValue() && (rowHeight = this.collectionRowHeightCache.get(this.currentUniqueDataFlag)) != null) {
            row.setHeight(rowHeight.shortValue());
        }
    }

    private List<AnalysisCell> readTemplateData(Map<UniqueDataFlagKey, List<AnalysisCell>> analysisCache) {
        List<AnalysisCell> analysisCellList = analysisCache.get(this.currentUniqueDataFlag);
        if (analysisCellList != null) {
            return analysisCellList;
        }
        Sheet sheet = this.writeContext.writeSheetHolder().getCachedSheet();
        HashMap<UniqueDataFlagKey, Set<Integer>> firstRowCache = MapUtils.newHashMapWithExpectedSize(8);
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                String preparedData;
                Cell cell = row.getCell(j);
                if (cell == null || (preparedData = this.prepareData(cell, i, j, firstRowCache)) == null) continue;
                cell.setCellValue(preparedData);
            }
        }
        return analysisCache.get(this.currentUniqueDataFlag);
    }

    private String prepareData(Cell cell, int rowIndex, int columnIndex, Map<UniqueDataFlagKey, Set<Integer>> firstRowCache) {
        int prefixIndex;
        if (!CellType.STRING.equals((Object)cell.getCellType())) {
            return null;
        }
        String value = cell.getStringCellValue();
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        StringBuilder preparedData = new StringBuilder();
        AnalysisCell analysisCell = null;
        int startIndex = 0;
        int length = value.length();
        int lastPrepareDataIndex = 0;
        block0: while (startIndex < length && (prefixIndex = value.indexOf(FILL_PREFIX, startIndex)) >= 0) {
            String variable;
            char prefixPrefixChar;
            if (prefixIndex != 0 && (prefixPrefixChar = value.charAt(prefixIndex - 1)) == '\\') {
                startIndex = prefixIndex + 1;
                continue;
            }
            int suffixIndex = -1;
            while (suffixIndex == -1 && startIndex < length) {
                suffixIndex = value.indexOf(FILL_SUFFIX, startIndex + 1);
                if (suffixIndex < 0) break block0;
                startIndex = suffixIndex + 1;
                char prefixSuffixChar = value.charAt(suffixIndex - 1);
                if (prefixSuffixChar != '\\') continue;
                suffixIndex = -1;
            }
            if (analysisCell == null) {
                analysisCell = this.initAnalysisCell(rowIndex, columnIndex);
            }
            if (StringUtils.isEmpty(variable = value.substring(prefixIndex + 1, suffixIndex))) continue;
            int collectPrefixIndex = variable.indexOf(COLLECTION_PREFIX);
            if (collectPrefixIndex > -1) {
                if (collectPrefixIndex != 0) {
                    analysisCell.setPrefix(variable.substring(0, collectPrefixIndex));
                }
                if (StringUtils.isEmpty(variable = variable.substring(collectPrefixIndex + 1))) continue;
                analysisCell.setCellType(WriteTemplateAnalysisCellTypeEnum.COLLECTION);
            }
            analysisCell.getVariableList().add(variable);
            if (lastPrepareDataIndex == prefixIndex) {
                analysisCell.getPrepareDataList().add("");
                if (lastPrepareDataIndex != 0) {
                    analysisCell.setOnlyOneVariable(Boolean.FALSE);
                }
            } else {
                String data = this.convertPrepareData(value.substring(lastPrepareDataIndex, prefixIndex));
                preparedData.append(data);
                analysisCell.getPrepareDataList().add(data);
                analysisCell.setOnlyOneVariable(Boolean.FALSE);
            }
            lastPrepareDataIndex = suffixIndex + 1;
        }
        if (analysisCell != null && CollectionUtils.isNotEmpty(analysisCell.getVariableList())) {
            cell.setBlank();
        }
        return this.dealAnalysisCell(analysisCell, value, rowIndex, lastPrepareDataIndex, length, firstRowCache, preparedData);
    }

    private String dealAnalysisCell(AnalysisCell analysisCell, String value, int rowIndex, int lastPrepareDataIndex, int length, Map<UniqueDataFlagKey, Set<Integer>> firstRowCache, StringBuilder preparedData) {
        if (analysisCell != null) {
            if (lastPrepareDataIndex == length) {
                analysisCell.getPrepareDataList().add("");
            } else {
                analysisCell.getPrepareDataList().add(this.convertPrepareData(value.substring(lastPrepareDataIndex)));
                analysisCell.setOnlyOneVariable(Boolean.FALSE);
            }
            UniqueDataFlagKey uniqueDataFlag = this.uniqueDataFlag(this.writeContext.writeSheetHolder(), analysisCell.getPrefix());
            if (WriteTemplateAnalysisCellTypeEnum.COMMON.equals((Object)analysisCell.getCellType())) {
                List analysisCellList = this.templateAnalysisCache.computeIfAbsent(uniqueDataFlag, key -> ListUtils.newArrayList());
                analysisCellList.add(analysisCell);
            } else {
                Set uniqueFirstRowCache = firstRowCache.computeIfAbsent(uniqueDataFlag, key -> new HashSet());
                if (!uniqueFirstRowCache.contains(rowIndex)) {
                    analysisCell.setFirstRow(Boolean.TRUE);
                    uniqueFirstRowCache.add(rowIndex);
                }
                List collectionAnalysisCellList = this.templateCollectionAnalysisCache.computeIfAbsent(uniqueDataFlag, key -> ListUtils.newArrayList());
                collectionAnalysisCellList.add(analysisCell);
            }
            return preparedData.toString();
        }
        return null;
    }

    private AnalysisCell initAnalysisCell(Integer rowIndex, Integer columnIndex) {
        AnalysisCell analysisCell = new AnalysisCell();
        analysisCell.setRowIndex(rowIndex);
        analysisCell.setColumnIndex(columnIndex);
        analysisCell.setOnlyOneVariable(Boolean.TRUE);
        ArrayList<String> variableList = ListUtils.newArrayList();
        analysisCell.setVariableList(variableList);
        ArrayList<String> prepareDataList = ListUtils.newArrayList();
        analysisCell.setPrepareDataList(prepareDataList);
        analysisCell.setCellType(WriteTemplateAnalysisCellTypeEnum.COMMON);
        analysisCell.setFirstRow(Boolean.FALSE);
        return analysisCell;
    }

    private String convertPrepareData(String prepareData) {
        prepareData = prepareData.replaceAll(ESCAPE_FILL_PREFIX, FILL_PREFIX);
        prepareData = prepareData.replaceAll(ESCAPE_FILL_SUFFIX, FILL_SUFFIX);
        return prepareData;
    }

    private UniqueDataFlagKey uniqueDataFlag(WriteSheetHolder writeSheetHolder, String wrapperName) {
        return new UniqueDataFlagKey(writeSheetHolder.getSheetNo(), writeSheetHolder.getSheetName(), wrapperName);
    }

    public static class UniqueDataFlagKey {
        private Integer sheetNo;
        private String sheetName;
        private String wrapperName;

        public Integer getSheetNo() {
            return this.sheetNo;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public String getWrapperName() {
            return this.wrapperName;
        }

        public void setSheetNo(Integer sheetNo) {
            this.sheetNo = sheetNo;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public void setWrapperName(String wrapperName) {
            this.wrapperName = wrapperName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UniqueDataFlagKey)) {
                return false;
            }
            UniqueDataFlagKey other = (UniqueDataFlagKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$sheetNo = this.getSheetNo();
            Integer other$sheetNo = other.getSheetNo();
            if (this$sheetNo == null ? other$sheetNo != null : !((Object)this$sheetNo).equals(other$sheetNo)) {
                return false;
            }
            String this$sheetName = this.getSheetName();
            String other$sheetName = other.getSheetName();
            if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
                return false;
            }
            String this$wrapperName = this.getWrapperName();
            String other$wrapperName = other.getWrapperName();
            return !(this$wrapperName == null ? other$wrapperName != null : !this$wrapperName.equals(other$wrapperName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UniqueDataFlagKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $sheetNo = this.getSheetNo();
            result = result * 59 + ($sheetNo == null ? 43 : ((Object)$sheetNo).hashCode());
            String $sheetName = this.getSheetName();
            result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
            String $wrapperName = this.getWrapperName();
            result = result * 59 + ($wrapperName == null ? 43 : $wrapperName.hashCode());
            return result;
        }

        public UniqueDataFlagKey(Integer sheetNo, String sheetName, String wrapperName) {
            this.sheetNo = sheetNo;
            this.sheetName = sheetName;
            this.wrapperName = wrapperName;
        }
    }
}

