/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.detail;

import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.InstructionSetRunner;
import com.ql.util.express.OperateData;
import com.ql.util.express.RunEnvironment;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.detail.Instruction;
import java.util.List;

public class InstructionCallMacro
extends Instruction {
    private final String name;

    public InstructionCallMacro(String name) {
        this.name = name;
    }

    @Override
    public void execute(RunEnvironment environment, List<String> errorList) throws Exception {
        if (environment.isTrace() && log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        InstructionSetContext context = environment.getContext();
        Object functionSet = context.getSymbol(this.name);
        Object result = InstructionSetRunner.execute(context.getExpressRunner(), (InstructionSet)functionSet, context.getExpressLoader(), context, errorList, environment.isTrace(), false, false, log, environment.getContext().isSupportDynamicFieldName());
        if (result instanceof OperateData) {
            environment.push((OperateData)result);
        } else {
            environment.push(OperateDataCacheManager.fetchOperateData(result, null));
        }
        environment.programPointAddOne();
    }

    public String toString() {
        return "call macro " + this.name;
    }
}

