/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.detail;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.InstructionSetRunner;
import com.ql.util.express.OperateData;
import com.ql.util.express.RunEnvironment;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.detail.Instruction;
import com.ql.util.express.instruction.opdata.OperateDataAttr;
import com.ql.util.express.instruction.opdata.OperateDataLocalVar;
import java.util.List;
import org.apache.commons.logging.Log;

public class InstructionCallSelfDefineFunction
extends Instruction {
    private final String functionName;
    private final int opDataNumber;

    public InstructionCallSelfDefineFunction(String name, int opDataNumber) {
        this.functionName = name;
        this.opDataNumber = opDataNumber;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getOpDataNumber() {
        return this.opDataNumber;
    }

    @Override
    public void execute(RunEnvironment environment, List<String> errorList) throws Exception {
        Object function;
        ArraySwap parameters = environment.popArray(this.opDataNumber);
        if (environment.isTrace() && log.isDebugEnabled()) {
            StringBuilder str = new StringBuilder(this.functionName + "(");
            for (int i = 0; i < parameters.length; ++i) {
                OperateData operateData = parameters.get(i);
                if (i > 0) {
                    str.append(",");
                }
                if (operateData instanceof OperateDataAttr) {
                    str.append(operateData).append(":").append(operateData.getObject(environment.getContext()));
                    continue;
                }
                str.append(operateData);
            }
            str.append(")");
            log.debug((Object)str.toString());
        }
        if (!((function = environment.getContext().getSymbol(this.functionName)) instanceof InstructionSet)) {
            throw new QLException(this.getExceptionPrefix() + "\u5728Runner\u7684\u64cd\u4f5c\u7b26\u5b9a\u4e49\u548c\u81ea\u5b9a\u4e49\u51fd\u6570\u4e2d\u90fd\u6ca1\u6709\u627e\u5230" + this.functionName + "\u7684\u5b9a\u4e49");
        }
        InstructionSet functionSet = (InstructionSet)function;
        OperateData result = InstructionCallSelfDefineFunction.executeSelfFunction(environment, functionSet, parameters, errorList, log);
        environment.push(result);
        environment.programPointAddOne();
    }

    public static OperateData executeSelfFunction(RunEnvironment environment, InstructionSet functionSet, ArraySwap parameters, List<String> errorList, Log log) throws Exception {
        InstructionSetContext context = OperateDataCacheManager.fetchInstructionSetContext(true, environment.getContext().getExpressRunner(), environment.getContext(), environment.getContext().getExpressLoader(), environment.getContext().isSupportDynamicFieldName());
        OperateDataLocalVar[] vars = functionSet.getParameters();
        for (int i = 0; i < vars.length; ++i) {
            OperateDataLocalVar operateDataLocalVar = OperateDataCacheManager.fetchOperateDataLocalVar(vars[i].getName(), vars[i].getOriginalType());
            context.addSymbol(operateDataLocalVar.getName(), operateDataLocalVar);
            operateDataLocalVar.setObject(context, parameters.get(i).getObject(environment.getContext()));
        }
        Object result = InstructionSetRunner.execute(functionSet, context, errorList, environment.isTrace(), false, true, log);
        return OperateDataCacheManager.fetchOperateData(result, null);
    }

    public String toString() {
        return "call Function[" + this.functionName + "] OPNUMBER[" + this.opDataNumber + "]";
    }
}

