// Copyright (c) Alibaba, Inc. and its affiliates.
package com.alibaba.dashscope.app;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

/**
 * Title Application call usage.<br>
 * Description Application call usage.<br>
 * Created at 2024-02-23 17:30
 *
 * @since jdk8
 */
@Data
@SuperBuilder
@ToString
public class ApplicationUsage {
  /** Completion usage for llm models */
  private List<ModelUsage> models;

  @SuperBuilder
  @Data
  @ToString
  public static class ModelUsage {
    /** model id, e.g. qwen-plus-v1 */
    @SerializedName("model_id")
    private String modelId;

    /** input tokens of prompt */
    @SerializedName("input_tokens")
    private Integer inputTokens;

    /** output tokens of response text that generated by LLM */
    @SerializedName("output_tokens")
    private Integer outputTokens;
  }
}
