/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.log4j2;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.spi.ThreadContextMap;

public class TtlThreadContextMap
implements ThreadContextMap {
    private final ThreadLocal<Map<String, String>> localMap = new TransmittableThreadLocal();

    public void put(String key, String value) {
        Map<String, String> map = this.localMap.get();
        map = map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
        map.put(key, value);
        this.localMap.set(Collections.unmodifiableMap(map));
    }

    public String get(String key) {
        Map<String, String> map = this.localMap.get();
        return map == null ? null : map.get(key);
    }

    public void remove(String key) {
        Map<String, String> map = this.localMap.get();
        if (map != null) {
            HashMap<String, String> copy = new HashMap<String, String>(map);
            copy.remove(key);
            this.localMap.set(Collections.unmodifiableMap(copy));
        }
    }

    public void clear() {
        this.localMap.remove();
    }

    public boolean containsKey(String key) {
        Map<String, String> map = this.localMap.get();
        return map != null && map.containsKey(key);
    }

    public Map<String, String> getCopy() {
        Map<String, String> map = this.localMap.get();
        return map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
    }

    public Map<String, String> getImmutableMapOrNull() {
        return this.localMap.get();
    }

    public boolean isEmpty() {
        Map<String, String> map = this.localMap.get();
        return map == null || map.size() == 0;
    }

    public String toString() {
        Map<String, String> map = this.localMap.get();
        return map == null ? "{}" : map.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        Map<String, String> map = this.localMap.get();
        result = 31 * result + (map == null ? 0 : map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadContextMap)) {
            return false;
        }
        ThreadContextMap other = (ThreadContextMap)obj;
        Map<String, String> map = this.localMap.get();
        Map otherMap = other.getImmutableMapOrNull();
        return !(map == null ? otherMap != null : !map.equals(otherMap));
    }
}

