// This file is auto-generated, don't edit it. Thanks.
package com.aliyun.dysmsapi20170525.models;

import com.aliyun.tea.*;

public class GetSmsTemplateResponseBody extends TeaModel {
    /**
     * <p>Application scenario content.</p>
     * 
     * <strong>example:</strong>
     * <p><a href="http://www.aliyun.com/">http://www.aliyun.com/</a></p>
     */
    @NameInMap("ApplyScene")
    public String applyScene;

    /**
     * <p>Audit information.</p>
     */
    @NameInMap("AuditInfo")
    public GetSmsTemplateResponseBodyAuditInfo auditInfo;

    /**
     * <p>Request status code.</p>
     * <ul>
     * <li>OK indicates a successful request.</li>
     * <li>For other error codes, please refer to <a href="https://help.aliyun.com/document_detail/101346.html">API Error Codes</a>.</li>
     * </ul>
     * 
     * <strong>example:</strong>
     * <p>OK</p>
     */
    @NameInMap("Code")
    public String code;

    /**
     * <p>The time when the SMS template was created.</p>
     * 
     * <strong>example:</strong>
     * <p>2024-06-03 10:02:34</p>
     */
    @NameInMap("CreateDate")
    public String createDate;

    /**
     * <p>File information, compatible with signatures created by the <a href="https://help.aliyun.com/zh/sms/developer-reference/api-dysmsapi-2017-05-25-addsmstemplate?spm">AddSmsSign</a> API.</p>
     */
    @NameInMap("FileUrlList")
    public GetSmsTemplateResponseBodyFileUrlList fileUrlList;

    /**
     * <p>International/Hong Kong, Macao, and Taiwan template type. When the <strong>TemplateType</strong> parameter is <strong>3</strong>, this parameter is required for international/Hong Kong, Macao, and Taiwan templates, with values:</p>
     * <ul>
     * <li><strong>0</strong>: Verification code.</li>
     * <li><strong>1</strong>: SMS notification.</li>
     * <li><strong>2</strong>: Promotional SMS.</li>
     * </ul>
     * 
     * <strong>example:</strong>
     * <p>0</p>
     */
    @NameInMap("IntlType")
    public Integer intlType;

    /**
     * <p>Description of the status code.</p>
     * 
     * <strong>example:</strong>
     * <p>OK</p>
     */
    @NameInMap("Message")
    public String message;

    /**
     * <p>Additional documentation information, supplementing uploaded business proof files or operational screenshots file list.</p>
     */
    @NameInMap("MoreDataFileUrlList")
    public GetSmsTemplateResponseBodyMoreDataFileUrlList moreDataFileUrlList;

    /**
     * <p>Work order number.</p>
     * <p>This parameter is used by auditors when querying the audit. You need to provide this work order number when requesting expedited review.</p>
     * 
     * <strong>example:</strong>
     * <p>2003019****</p>
     */
    @NameInMap("OrderId")
    public String orderId;

    /**
     * <p>The SMS signature associated with the template when applied.</p>
     * 
     * <strong>example:</strong>
     * <p>阿里云</p>
     */
    @NameInMap("RelatedSignName")
    public String relatedSignName;

    /**
     * <p>Explanation for the SMS template application, which is one of the reference information for template review.</p>
     * 
     * <strong>example:</strong>
     * <p>申请验证码模板</p>
     */
    @NameInMap("Remark")
    public String remark;

    /**
     * <p>The ID of this call request, which is a unique identifier generated by Alibaba Cloud for the request and can be used for troubleshooting and issue定位.</p>
     * 
     * <strong>example:</strong>
     * <p>819BE656-D2E0-4858-8B21-B2E47708****</p>
     */
    @NameInMap("RequestId")
    public String requestId;

    /**
     * <p>SMS template code.</p>
     * 
     * <strong>example:</strong>
     * <p>SMS_20375****</p>
     */
    @NameInMap("TemplateCode")
    public String templateCode;

    /**
     * <p>Content of the SMS template.</p>
     * 
     * <strong>example:</strong>
     * <p>您正在申请手机注册，验证码为：${code}，5分钟内有效！</p>
     */
    @NameInMap("TemplateContent")
    public String templateContent;

    /**
     * <p>Name of the SMS template.</p>
     * 
     * <strong>example:</strong>
     * <p>验证码</p>
     */
    @NameInMap("TemplateName")
    public String templateName;

    /**
     * <p>Template review status. Return values:</p>
     * <ul>
     * <li><strong>0</strong>: Under review.</li>
     * <li><strong>1</strong>: Approved.</li>
     * <li><strong>2</strong>: Not approved, with reasons for failure returned. Please refer to <a href="https://help.aliyun.com/zh/sms/user-guide/causes-of-application-failures-and-suggestions?spm=a2c4g.11186623.0.0.41fd339f3bPSCQ">Handling Suggestions for Failed SMS Reviews</a>, invoke the <a href="https://help.aliyun.com/zh/sms/developer-reference/api-dysmsapi-2017-05-25-updatesmstemplate?spm">UpdateSmsTemplate</a> API or modify the SMS template on the <a href="https://dysms.console.aliyun.com/domestic/text/template">Template Management</a> page.</li>
     * <li><strong>10</strong>: Review canceled.</li>
     * </ul>
     * 
     * <strong>example:</strong>
     * <p>2</p>
     */
    @NameInMap("TemplateStatus")
    public String templateStatus;

    /**
     * <p>Template identifier, indicating whether the template is user-defined or system-provided. Values:</p>
     * <ul>
     * <li><p><strong>2</strong>: User-defined template.</p>
     * </li>
     * <li><p><strong>3</strong>: System-provided template.</p>
     * </li>
     * </ul>
     * 
     * <strong>example:</strong>
     * <p>2</p>
     */
    @NameInMap("TemplateTag")
    public Integer templateTag;

    /**
     * <p>SMS type. Values:</p>
     * <ul>
     * <li><strong>0</strong>: Verification code.</li>
     * <li><strong>1</strong>: SMS notification.</li>
     * <li><strong>2</strong>: Promotional SMS.</li>
     * <li><strong>3</strong>: International/Hong Kong, Macao, and Taiwan messages.</li>
     * </ul>
     * <blockquote>
     * <p>Only enterprise-certified users can apply for promotional SMS and international/Hong Kong, Macao, and Taiwan messages. For details on the differences between personal and enterprise user rights, please refer to <a href="https://help.aliyun.com/zh/sms/user-guide/usage-notes?spm=a2c4g.11186623.0.0.67447f576NJnE8">Usage Notes</a>.</p>
     * </blockquote>
     * 
     * <strong>example:</strong>
     * <p>0</p>
     */
    @NameInMap("TemplateType")
    public String templateType;

    /**
     * <p>Template variable rules.</p>
     * <p>For detailed rules of template variables, refer to the <a href="https://help.aliyun.com/zh/sms/templaterule-template-variable-parameter-filling-example">Example Document</a>.</p>
     * 
     * <strong>example:</strong>
     * <p>{&quot;code&quot;:&quot;characterWithNumber&quot;}</p>
     */
    @NameInMap("VariableAttribute")
    public String variableAttribute;

    public static GetSmsTemplateResponseBody build(java.util.Map<String, ?> map) throws Exception {
        GetSmsTemplateResponseBody self = new GetSmsTemplateResponseBody();
        return TeaModel.build(map, self);
    }

    public GetSmsTemplateResponseBody setApplyScene(String applyScene) {
        this.applyScene = applyScene;
        return this;
    }
    public String getApplyScene() {
        return this.applyScene;
    }

    public GetSmsTemplateResponseBody setAuditInfo(GetSmsTemplateResponseBodyAuditInfo auditInfo) {
        this.auditInfo = auditInfo;
        return this;
    }
    public GetSmsTemplateResponseBodyAuditInfo getAuditInfo() {
        return this.auditInfo;
    }

    public GetSmsTemplateResponseBody setCode(String code) {
        this.code = code;
        return this;
    }
    public String getCode() {
        return this.code;
    }

    public GetSmsTemplateResponseBody setCreateDate(String createDate) {
        this.createDate = createDate;
        return this;
    }
    public String getCreateDate() {
        return this.createDate;
    }

    public GetSmsTemplateResponseBody setFileUrlList(GetSmsTemplateResponseBodyFileUrlList fileUrlList) {
        this.fileUrlList = fileUrlList;
        return this;
    }
    public GetSmsTemplateResponseBodyFileUrlList getFileUrlList() {
        return this.fileUrlList;
    }

    public GetSmsTemplateResponseBody setIntlType(Integer intlType) {
        this.intlType = intlType;
        return this;
    }
    public Integer getIntlType() {
        return this.intlType;
    }

    public GetSmsTemplateResponseBody setMessage(String message) {
        this.message = message;
        return this;
    }
    public String getMessage() {
        return this.message;
    }

    public GetSmsTemplateResponseBody setMoreDataFileUrlList(GetSmsTemplateResponseBodyMoreDataFileUrlList moreDataFileUrlList) {
        this.moreDataFileUrlList = moreDataFileUrlList;
        return this;
    }
    public GetSmsTemplateResponseBodyMoreDataFileUrlList getMoreDataFileUrlList() {
        return this.moreDataFileUrlList;
    }

    public GetSmsTemplateResponseBody setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }
    public String getOrderId() {
        return this.orderId;
    }

    public GetSmsTemplateResponseBody setRelatedSignName(String relatedSignName) {
        this.relatedSignName = relatedSignName;
        return this;
    }
    public String getRelatedSignName() {
        return this.relatedSignName;
    }

    public GetSmsTemplateResponseBody setRemark(String remark) {
        this.remark = remark;
        return this;
    }
    public String getRemark() {
        return this.remark;
    }

    public GetSmsTemplateResponseBody setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }
    public String getRequestId() {
        return this.requestId;
    }

    public GetSmsTemplateResponseBody setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
        return this;
    }
    public String getTemplateCode() {
        return this.templateCode;
    }

    public GetSmsTemplateResponseBody setTemplateContent(String templateContent) {
        this.templateContent = templateContent;
        return this;
    }
    public String getTemplateContent() {
        return this.templateContent;
    }

    public GetSmsTemplateResponseBody setTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }
    public String getTemplateName() {
        return this.templateName;
    }

    public GetSmsTemplateResponseBody setTemplateStatus(String templateStatus) {
        this.templateStatus = templateStatus;
        return this;
    }
    public String getTemplateStatus() {
        return this.templateStatus;
    }

    public GetSmsTemplateResponseBody setTemplateTag(Integer templateTag) {
        this.templateTag = templateTag;
        return this;
    }
    public Integer getTemplateTag() {
        return this.templateTag;
    }

    public GetSmsTemplateResponseBody setTemplateType(String templateType) {
        this.templateType = templateType;
        return this;
    }
    public String getTemplateType() {
        return this.templateType;
    }

    public GetSmsTemplateResponseBody setVariableAttribute(String variableAttribute) {
        this.variableAttribute = variableAttribute;
        return this;
    }
    public String getVariableAttribute() {
        return this.variableAttribute;
    }

    public static class GetSmsTemplateResponseBodyAuditInfo extends TeaModel {
        /**
         * <p>Audit date and time.</p>
         * 
         * <strong>example:</strong>
         * <p>2024-06-03 11:20:34</p>
         */
        @NameInMap("AuditDate")
        public String auditDate;

        /**
         * <p>Reasons for failed audit.</p>
         * 
         * <strong>example:</strong>
         * <p>模板内容中包含错别字。</p>
         */
        @NameInMap("RejectInfo")
        public String rejectInfo;

        public static GetSmsTemplateResponseBodyAuditInfo build(java.util.Map<String, ?> map) throws Exception {
            GetSmsTemplateResponseBodyAuditInfo self = new GetSmsTemplateResponseBodyAuditInfo();
            return TeaModel.build(map, self);
        }

        public GetSmsTemplateResponseBodyAuditInfo setAuditDate(String auditDate) {
            this.auditDate = auditDate;
            return this;
        }
        public String getAuditDate() {
            return this.auditDate;
        }

        public GetSmsTemplateResponseBodyAuditInfo setRejectInfo(String rejectInfo) {
            this.rejectInfo = rejectInfo;
            return this;
        }
        public String getRejectInfo() {
            return this.rejectInfo;
        }

    }

    public static class GetSmsTemplateResponseBodyFileUrlList extends TeaModel {
        @NameInMap("FileUrl")
        public java.util.List<String> fileUrl;

        public static GetSmsTemplateResponseBodyFileUrlList build(java.util.Map<String, ?> map) throws Exception {
            GetSmsTemplateResponseBodyFileUrlList self = new GetSmsTemplateResponseBodyFileUrlList();
            return TeaModel.build(map, self);
        }

        public GetSmsTemplateResponseBodyFileUrlList setFileUrl(java.util.List<String> fileUrl) {
            this.fileUrl = fileUrl;
            return this;
        }
        public java.util.List<String> getFileUrl() {
            return this.fileUrl;
        }

    }

    public static class GetSmsTemplateResponseBodyMoreDataFileUrlList extends TeaModel {
        @NameInMap("MoreDataFileUrl")
        public java.util.List<String> moreDataFileUrl;

        public static GetSmsTemplateResponseBodyMoreDataFileUrlList build(java.util.Map<String, ?> map) throws Exception {
            GetSmsTemplateResponseBodyMoreDataFileUrlList self = new GetSmsTemplateResponseBodyMoreDataFileUrlList();
            return TeaModel.build(map, self);
        }

        public GetSmsTemplateResponseBodyMoreDataFileUrlList setMoreDataFileUrl(java.util.List<String> moreDataFileUrl) {
            this.moreDataFileUrl = moreDataFileUrl;
            return this;
        }
        public java.util.List<String> getMoreDataFileUrl() {
            return this.moreDataFileUrl;
        }

    }

}
