/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.override;

import com.baomidou.mybatisplus.core.metadata.MapperProxyMetadata;
import com.baomidou.mybatisplus.core.override.MybatisMapperMethod;
import com.baomidou.mybatisplus.core.plugins.IgnoreStrategy;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.MybatisUtils;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.util.MapUtil;

public class MybatisMapperProxy<T>
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -4724728412955527868L;
    private static final int ALLOWED_MODES = 15;
    private static final Constructor<MethodHandles.Lookup> lookupConstructor;
    private static final Method privateLookupInMethod;
    private final SqlSession sqlSession;
    private final Class<T> mapperInterface;
    private final Map<Method, MapperMethodInvoker> methodCache;

    public MybatisMapperProxy(SqlSession sqlSession, Class<T> mapperInterface, Map<Method, MapperMethodInvoker> methodCache) {
        this.sqlSession = sqlSession;
        this.mapperInterface = mapperInterface;
        this.methodCache = methodCache;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            return this.cachedInvoker(method).invoke(proxy, method, args, this.sqlSession);
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable((Throwable)t);
        }
    }

    private MapperMethodInvoker cachedInvoker(Method method) throws Throwable {
        try {
            return (MapperMethodInvoker)MapUtil.computeIfAbsent(this.methodCache, (Object)method, m -> {
                if (!m.isDefault()) {
                    return new PlainMethodInvoker(new MybatisMapperMethod(this.mapperInterface, method, this.sqlSession.getConfiguration()));
                }
                try {
                    if (privateLookupInMethod == null) {
                        return new DefaultMethodInvoker(this.getMethodHandleJava8(method));
                    }
                    return new DefaultMethodInvoker(this.getMethodHandleJava9(method));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            throw cause == null ? re : cause;
        }
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public Class<T> getMapperInterface() {
        return this.mapperInterface;
    }

    private MethodHandle getMethodHandleJava9(Method method) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> declaringClass = method.getDeclaringClass();
        return ((MethodHandles.Lookup)privateLookupInMethod.invoke(null, declaringClass, MethodHandles.lookup())).findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
    }

    private MethodHandle getMethodHandleJava8(Method method) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> declaringClass = method.getDeclaringClass();
        return lookupConstructor.newInstance(declaringClass, 15).unreflectSpecial(method, declaringClass);
    }

    static {
        Method privateLookupIn;
        try {
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException e) {
            privateLookupIn = null;
        }
        privateLookupInMethod = privateLookupIn;
        Constructor lookup = null;
        if (privateLookupInMethod == null) {
            try {
                lookup = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                lookup.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("There is neither 'privateLookupIn(Class, Lookup)' nor 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
            }
            catch (Exception e) {
                lookup = null;
            }
        }
        lookupConstructor = lookup;
    }

    static interface MapperMethodInvoker {
        public Object invoke(Object var1, Method var2, Object[] var3, SqlSession var4) throws Throwable;
    }

    private static class PlainMethodInvoker
    implements MapperMethodInvoker {
        private final MybatisMapperMethod mapperMethod;

        public PlainMethodInvoker(MybatisMapperMethod mapperMethod) {
            this.mapperMethod = mapperMethod;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args, SqlSession sqlSession) throws Throwable {
            return this.mapperMethod.execute(sqlSession, args);
        }
    }

    private static class DefaultMethodInvoker
    implements MapperMethodInvoker {
        private final MethodHandle methodHandle;

        public DefaultMethodInvoker(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args, SqlSession sqlSession) throws Throwable {
            boolean hasIgnoreStrategy = InterceptorIgnoreHelper.hasIgnoreStrategy();
            if (hasIgnoreStrategy) {
                return this.methodHandle.bindTo(proxy).invokeWithArguments(args);
            }
            try {
                MapperProxyMetadata mapperProxyMetadata = MybatisUtils.getMapperProxy(proxy);
                Class<?> mapperInterface = mapperProxyMetadata.getMapperInterface();
                IgnoreStrategy ignoreStrategy = InterceptorIgnoreHelper.findIgnoreStrategy(mapperInterface, method);
                if (ignoreStrategy == null) {
                    ignoreStrategy = IgnoreStrategy.builder().build();
                }
                InterceptorIgnoreHelper.handle(ignoreStrategy);
                Object object = this.methodHandle.bindTo(proxy).invokeWithArguments(args);
                return object;
            }
            finally {
                InterceptorIgnoreHelper.clearIgnoreStrategy();
            }
        }
    }
}

