/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.ITableFieldAnnotationHandler;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.model.AnnotationAttributes;
import java.util.ArrayList;
import java.util.List;

public class DefaultTableFieldAnnotationHandler
implements ITableFieldAnnotationHandler {
    @Override
    public List<AnnotationAttributes> handle(TableInfo tableInfo, TableField tableField) {
        ArrayList<AnnotationAttributes> annotationAttributesList = new ArrayList<AnnotationAttributes>();
        GlobalConfig globalConfig = tableInfo.getGlobalConfig();
        Entity entity = tableField.getEntity();
        String comment = tableField.getComment();
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            String displayName;
            if (globalConfig.isSpringdoc()) {
                displayName = String.format("@Schema(description = \"%s\")", comment);
                annotationAttributesList.add(new AnnotationAttributes(displayName, "io.swagger.v3.oas.annotations.media.Schema"));
            } else if (globalConfig.isSwagger()) {
                displayName = String.format("@ApiModelProperty(\"%s\")", comment);
                annotationAttributesList.add(new AnnotationAttributes(displayName, "io.swagger.annotations.ApiModelProperty"));
            }
        }
        if (tableField.isKeyFlag()) {
            IdType idType = entity.getIdType();
            if (tableField.isKeyIdentityFlag()) {
                String displayName = String.format("@TableId(value = \"%s\", type = IdType.AUTO)", tableField.getAnnotationColumnName());
                annotationAttributesList.add(new AnnotationAttributes(displayName, TableId.class.getName()));
            } else if (idType != null) {
                String displayName = String.format("@TableId(value = \"%s\", type = IdType.%s)", tableField.getAnnotationColumnName(), idType);
                annotationAttributesList.add(new AnnotationAttributes(displayName, TableId.class.getName()));
            } else if (tableField.isConvert()) {
                String displayName = String.format("@TableId(\"%s\")", tableField.getAnnotationColumnName());
                annotationAttributesList.add(new AnnotationAttributes(displayName, TableId.class.getName()));
            }
        } else {
            String fill = tableField.getFill();
            if (StringUtils.isNotBlank((CharSequence)fill)) {
                if (tableField.isConvert()) {
                    String displayName = String.format("@TableField(value = \"%s\", fill = FieldFill.%s)", tableField.getAnnotationColumnName(), fill);
                    annotationAttributesList.add(new AnnotationAttributes(displayName, com.baomidou.mybatisplus.annotation.TableField.class.getName()));
                } else {
                    String displayName = String.format("@TableField(fill = FieldFill.%s)", fill);
                    annotationAttributesList.add(new AnnotationAttributes(displayName, com.baomidou.mybatisplus.annotation.TableField.class.getName()));
                }
            } else if (tableField.isConvert()) {
                String displayName = String.format("@TableField(\"%s\")", tableField.getAnnotationColumnName());
                annotationAttributesList.add(new AnnotationAttributes(displayName, com.baomidou.mybatisplus.annotation.TableField.class.getName()));
            }
            if (tableField.isVersionField()) {
                annotationAttributesList.add(new AnnotationAttributes(Version.class));
            }
            if (tableField.isLogicDeleteField()) {
                annotationAttributesList.add(new AnnotationAttributes(TableLogic.class));
            }
        }
        return annotationAttributesList;
    }
}

