package com.beiming.basic.chat.api;


import com.beiming.basic.chat.api.dto.response.MessageHistoryResDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.beiming.basic.chat.api.dto.request.ListMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.MemberReqDTO;
import com.beiming.basic.chat.api.dto.request.MemberUserReqDTO;
import com.beiming.basic.chat.api.dto.request.SendSystemMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.UpdateFileStatusReqDTO;
import com.beiming.basic.chat.api.dto.request.UpdateMemberUserReqDTO;
import com.beiming.basic.chat.api.dto.response.MediationRoomMemberDTO;
import com.beiming.basic.chat.api.dto.response.MemberResDTO;
import com.beiming.basic.chat.api.dto.response.MessageResDTO;
import com.beiming.framework.domain.DubboResult;

@Valid
public interface MediationChatRoomApi {
  /**
   * 查询历史联系人
   */
  public DubboResult<ArrayList<MemberResDTO>> listHistoryMember(Long roomId, Long userId);
  /**
   * 查询单个私聊或群聊数据
   */
  public DubboResult<ArrayList<MessageResDTO>> listMessage(ListMessageReqDTO req);
  /**
   * 查询所有聊天记录
   */
  public DubboResult<ArrayList<MessageResDTO>> listMessageByKeyword(Long roomId, Long userId, String keyword);
  /**
   * 查询聊天记录上下文
   */
  public DubboResult<ArrayList<MessageResDTO>> searchChatRecordsContext(Long messageId);
  
  /**
   * 异步调节专用添加人员
   * 
   * @param appendDTO
   * @return
   */
  public DubboResult<Boolean> addMediationRoomUser(List<MemberReqDTO> list, String roomId);

  /**
   * 删异步调节专用删除人员
   * 
   * @return
   */
  DubboResult<Boolean> deleteRoomMember(List<MemberReqDTO> list, String roomId);

  /**
   * 异步调节修改添加人员
   * 
   * @return
   */
  DubboResult<Boolean> updateRoomMember(UpdateMemberUserReqDTO dto);
  
  /**
   * 根据房间id查询人员
   * 
   * @return
   */
  DubboResult<ArrayList<MediationRoomMemberDTO>> getRoomUser(MemberUserReqDTO memberUserReqDTO);
  
  DubboResult<Integer> countRoomUser(Long roomId);

  /**
   * 更新文件是否上传至证据
   * 
   * @param messageId
   * @param fileId
   * @return
   */
  DubboResult updateFileStatus(List<UpdateFileStatusReqDTO> list);
  
  /**
   * 是否存在未读消息
   * 
   * @return
   */
  DubboResult<Boolean> isExistUnreadMessage(MemberUserReqDTO memberUserReqDTO);
  
  /**
   * 发送系统类消息
   *
   * @param dto
   */
  DubboResult sendCaseCirculationMessage(@Valid SendSystemMessageReqDTO dto);

  /**
   * 查询普通聊天信息或者私信
   * @param roomId 房间id
   * @param  userId 当前用户id
   * */
  DubboResult<ArrayList<MessageHistoryResDTO>> getMessage(Long roomId, String userId);

  /**
   * 获取某个调解员的所有视频录制时长
   * @param  userId 当前用户id
   * */
  DubboResult<BigDecimal> getRoomTime(String userId);
}
