package com.beiming.basic.chat.api;


import com.beiming.basic.chat.api.dto.response.KickOutMemberResDTO;
import com.beiming.basic.chat.api.dto.response.MediationRoomMemberDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.dto.request.ChatRoomReqDTO;
import com.beiming.basic.chat.api.dto.request.CountRoomReqDTO;
import com.beiming.basic.chat.api.dto.request.DelChatRecordReqDTO;
import com.beiming.basic.chat.api.dto.request.ListPrivateRoomReqDTO;
import com.beiming.basic.chat.api.dto.request.ListRoomReqDTO;
import com.beiming.basic.chat.api.dto.request.ListUserRoomReqDTO;
import com.beiming.basic.chat.api.dto.request.RoomAttributeInfoResDTO;
import com.beiming.basic.chat.api.dto.request.SendTextMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.UpdateChatRoomMembersReqDTO;
import com.beiming.basic.chat.api.dto.request.UpdateMemberDTO;
import com.beiming.basic.chat.api.dto.response.MemberResDTO;
import com.beiming.basic.chat.api.dto.response.MessageResDTO;
import com.beiming.basic.chat.api.dto.response.OnLineMemberInfoResDTO;
import com.beiming.basic.chat.api.dto.response.RoomInfoResDTO;
import com.beiming.basic.chat.api.dto.response.ThirdPartyRoomMemberResDTO;
import com.beiming.framework.domain.DubboResult;

/**
 * 聊天、视频服务 -- 微解纷专用
 * 
 * @author chenjt
 *
 */
@Valid
public interface RoomMediationApi {

  /**
   * 房间列表查询接口
   *
   * @param reqDTO
   * @return
   * @note Add by djq 2019-01-18
   */
  DubboResult<ArrayList<RoomInfoResDTO>> listRoom(@Valid ListRoomReqDTO reqDTO);

  /**
   * 房间统计接口
   *
   * @param reqDTO
   * @return
   * @note Add by djq 2019-01-18
   */
  DubboResult<Integer> countRoom(@Valid CountRoomReqDTO reqDTO);

  /**
   * 个人待办列表查询接口
   *
   * @param reqDTO
   * @return
   * @note Add by chenjt 2019-01-23
   */
  DubboResult<ArrayList<RoomInfoResDTO>> userRoomStayList(@Valid ListUserRoomReqDTO reqDTO);


  /**
   * 更新房间成员姓名
   * 
   * @param reqDTO
   * @return
   */
  DubboResult<Boolean> updateMemberName(@Valid UpdateMemberDTO reqDTO);

  /**
   * 传入成员ID 更新此成员ID所在房间中的状态为OFFLINE
   * 
   * @param memberId
   */
  void quitAllRoom(String memberId);

  /**
   * 传入转义后的房间ID,响应一个map,key为入参的房间ID,value为对应的room_info表的主键(对应改造新增)
   * 
   * @param roomIdList
   * @return resourceId -- key; primaryId - value
   */
  DubboResult<JSONObject> getRoomInfoPrimaryIds(@Valid List<String> roomIdList);

  public DubboResult<MessageResDTO> sendTextMessage(SendTextMessageReqDTO dto);

  public DubboResult<Integer> deleteRoom(String subjectId, String userName);
  
  DubboResult<RoomAttributeInfoResDTO> getRoomByRoomId(String roomId);
  
  /**
      * 第三方获取房间成员信息
   * @param roomId
   * @return
   */
  DubboResult<ThirdPartyRoomMemberResDTO> thirdPartyGetRoomInfo(String roomId);
  /**
   * 根据业务ID,成员id列表,创建私聊房间,如果已经创建则返回房间ID 
   * @param roomRequestDTO
   * @return 房间表主键
   */
  DubboResult<String> createPrivateChatRoomIfNotExist(ChatRoomReqDTO roomRequestDTO);
  /**
   * 查询在线成员信息
   * @param roomId
   * @return
   */
  DubboResult<ArrayList<OnLineMemberInfoResDTO>> getOnLineMember(String roomId);
  
  DubboResult<ArrayList<MessageResDTO>> listPrivateRoomMember(ListPrivateRoomReqDTO dto);
  /**
   * <pre>
   * 删除证据材料时,删除对应聊天记录里面的内容,如果一个聊天内容就一个证据材料,则调用此方法后,此聊天记录状态设置为1,
   * 如果一个聊天内容里面有多个证据材料,则此聊天记录还在,对应的证据材料文件信息被删除了
   * @param req
   * @return
   */
  DubboResult deleteChatRecord(DelChatRecordReqDTO req);
  /**
   * 智慧庭审编辑案件空间对应群聊房间信息(不创建新房间,将原有房间内的成员status字段设置为1,重新插入成员信息)
   * @param req
   * @return
   */
  DubboResult<String> updateChatRoomMembers(UpdateChatRoomMembersReqDTO req);

  /**
   * 将新成员插入聊天室
   * @param req
   * @return
   */
  DubboResult<String> updateChatRoomMembers2(UpdateChatRoomMembersReqDTO req);
  
  /**
   * 房间id获取真实房间id
   * @param roomId
   * @return
   */
  DubboResult<String> getRealRoomId(String roomId);
  
  /**
   * 查询房间成员
   * @param roomId
   * @return
   */
  DubboResult<ArrayList<MemberResDTO>> getRoomMembers(String roomId);

  /**
   * 修改房间成员状态
   * @param roomId
   * @param memberId
   * @return
   */
  DubboResult<Integer> changeMemberStatus(String roomId, Long memberId);

  /**
   * 根据房间号获取在线的用户信息
   * @param roomId
   * @return
   */
  DubboResult<ArrayList<MediationRoomMemberDTO>> getMembersByRoomId(Integer roomId);

  /**
   * 根据id获取房间号
   */
  DubboResult<String> getRoomIdById(String id);

  /**
   * 根据roomId和userId获取用户信息
   *
   * @param userId
   * @param roomId
   * @return
   */
  DubboResult<KickOutMemberResDTO> getMemberDetailByIdAndRoomId(String userId, String roomId);

  /**
   * 根据真实房间id获取subject_id
   */
  DubboResult<String> getSubjectIdByRoomId(String roomId);


  /**
   * 判断是否质证中
   * (最早一个证据开始质证，为质证中)
   *
   */
  DubboResult<Boolean> judgeSuspect(Long subjectId);
}
