package com.beiming.basic.chat.api.dto.request;

import java.util.List;
import com.beiming.framework.page.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class InductionEvidenceReqDTO extends PageQuery {

  private static final long serialVersionUID = -6239310282065986487L;
  /**
   * 房间id
   */
  private List<String> roomIds;

  /**
   * 数据权限
   * ALL: 所有人可见
   * APPLICANT: 原告可见（原告和原告代理人）
   * RESPONDENT: 被告可见 （被告和被告代理人）
   * LITIGANT_THIRD: 第三人可见 （第三人和第三人代理人）
   * LITIGANT_OTHER:其他诉讼参与人 （其他诉讼参与人）
   */
  private String dataPermission;

  /**
   * 提供方id
   */
  private List<Long> senderId;
}
