package com.beiming.basic.chat.api.dto.request;

import javax.validation.constraints.NotBlank;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 房间dto
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class JoinRoomReqDTO extends RoomMemberReqDTO {
  private static final long serialVersionUID = 5239372647777499935L;

  /**
   * 实时音视频的bizId
   */
  @NotBlank(message = ChatApiValidationMessage.STREAM_ID_NOT_BLANK)
  private String bizId;

  public JoinRoomReqDTO(String roomId, String memberId, String bizId) {
    super(roomId, memberId);
    this.bizId = bizId;
  }
}
