package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.constants.ChatApiConstant;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@SuppressWarnings("serial")
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@AllArgsConstructor
public class ListPrivateRoomReqDTO implements Serializable {
  /**
   * 调解室id
   */
  @NotNull(message = ChatApiValidationMessage.SUBJECT_ID_NOT_BLANK)
  @Size(max = ChatApiConstant.SUBJECT_ID_MAX_SIZE, message = "调解室ID长度超出限制")
  protected Long caseId;
  /**
   * 在线庭审d
   */
  @Size(max = ChatApiConstant.SUBJECT_ID_MAX_SIZE, message = "在线庭审ID长度超出限制")
  protected Long meetingId;
  /**
   * 成员ID
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  protected String memberId;
}
