package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 分页查看房间信息
 * 
 * @author djq
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class ListRoomReqDTO implements Serializable { // extends PageQuery

  /**
   * 
   */
  private static final long serialVersionUID = 8801937422127201385L;

  /**
   * 成员id
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String memberId;

  /**
   * 成员类型<br>
   * 
   * 管理员 MASTER<br>
   * 普通参与人 NORMAL
   * 
   * @see MemberRoleTypeEnums
   */
  // @NotBlank(message = ChatApiValidationMessage.MEMBER_TYPE_NOT_BLANK)
  // private String memberRoleType;

  /**
   * 房间状态<br>
   */
  private String roomStatus;

  /**
   * 房间类型<br>
   * 业务层面上的房间类型<br>
   * 对应subject_type
   * 
   * @see MediationMeetingTypeEnum
   */
  private String businessRoomType;

  /**
   * 成员姓名
   */
  private String memberName;

  // public ListRoomReqDTO(String memberId, Integer pageIndex, Integer pageSize) {
  // super(pageIndex, pageSize);
  // this.memberId = memberId;
  // }
  //
  // public ListRoomReqDTO(String memberId, String businessRoomType, Integer pageIndex,
  // Integer pageSize) {
  // super(pageIndex, pageSize);
  // this.memberId = memberId;
  // this.businessRoomType = businessRoomType;
  // }

  public ListRoomReqDTO(String memberId) {
    this.memberId = memberId;
  }

  public ListRoomReqDTO(String memberId, String businessRoomType) {
    this.memberId = memberId;
    this.businessRoomType = businessRoomType;
  }

}
