package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 异步调节房间人员请求
 * 
 * @author huaisf
 *
 */
@Data
@NoArgsConstructor
public class MemberUserReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * 房间id
   */
  private Long roomId;

  /**
   * 成员id
   */
  private String userId;

  /**
   * 是否为管理员
   */
  private Boolean master;

  public MemberUserReqDTO(Long roomId, String userId, Boolean master) {
    this.roomId = roomId;
    this.master = master;
    this.userId = userId;
  }
}
