package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 分页查看消息
 * 
 * @author lb
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class RevokeMsgDto implements Serializable {

  private static final long serialVersionUID = -5287501277987832511L;

  /**
   * 房间id
   */
  private String roomId;

  /**
   * 消息ID
   */
  @NotNull(message = "消息ID不能为空")
  private Long msgId;

  /**
   * 发送人id
   */
  private String senderId;

}
