package com.beiming.basic.chat.api.dto.request;

import com.beiming.basic.chat.api.ChatApiValidationMessage;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class SendActionMessageReqDTO extends SendMessageReqDTO {


  private static final long serialVersionUID = -1271793729230614248L;



  /**
   * 诉讼事项id
   */
  @NotBlank(message = ChatApiValidationMessage.ACTION_ID_NOT_BLANK)
  private String actionId;
  /**
   * 文件名
   */
  @NotBlank(message = ChatApiValidationMessage.ACTION_TITLE_NOT_BLANK)
  private String title;
  /**
   * 内容
   */
//  @NotBlank(message = ChatApiValidationMessage.ACTION_TITLE_NOT_BLANK)
  private String content;
  /**
   * 富文本内容
   */
//  @NotBlank(message = ChatApiValidationMessage.ACTION_TITLE_NOT_BLANK)
  private String richText;
  /**
   * 发送时间
   */
//  @NotBlank(message = ChatApiValidationMessage.ACTION_TITLE_NOT_BLANK)
  private Date sendTime;
  /**
   * 过期小时
   */
//  @NotBlank(message = ChatApiValidationMessage.ACTION_TITLE_NOT_BLANK)
  private Integer expirationTime;

  /**
   *查询的相关内容
   */
  private String searchContent;

  /**
   * 已读消息人员id
   */
  private String readUserIds;

  public SendActionMessageReqDTO(String roomId, String senderId, String receiverId, String actionId,
      String title, String content, String richText, Integer expirationTime) {
    super(roomId, senderId, receiverId);
    this.actionId = actionId;
    this.title = title;
  }
}
