package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 新建房间dto
 * 
 * @author lb
 *
 */
@SuppressWarnings("serial")
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class UpdateChatRoomMembersReqDTO extends ChatRoomReqDTO implements Serializable {
  @NotBlank(message = "聊天室房间号不能为空")
  private String roomId;

  public UpdateChatRoomMembersReqDTO(ChatRoomReqDTO superObj, String roomId) {
    super(superObj.getSubjectType(), superObj.getSubjectId(), superObj.getMembers(), superObj.getRoomAttributes());
    this.roomId = roomId;
  }

}
