package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.constants.ChatApiConstant;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 更新房间成员信息dto
 * 
 * @author djq
 *
 */
@Data
@NoArgsConstructor
public class UpdateMemberDTO implements Serializable {

  private static final long serialVersionUID = -7477856287698446154L;

  /**
   * 房间主键id
   */
  private String roomId;

  /**
   * 成员id
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  @Size(max = ChatApiConstant.MEMBER_ID_MAX_SIZE,
      message = ChatApiValidationMessage.MEMBER_ID_TOO_LONG)
  private String memberId;

  /**
   * 成员名称
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_NAME_NOT_BLANK)
  @Size(max = ChatApiConstant.MEMBER_NAME_MAX_SIZE,
      message = ChatApiValidationMessage.MEMBER_NAME_TOO_LONG)
  private String memberName;

  /**
   * 成员类型
   */
  private String memberType;

  /**
   * 成员title
   */
  private String title;

  /**
   * 更新房间成员构造方法
   * 
   * @param memberId 成员id，不允许为空
   * @param memberName 成员名称，不允许为空
   */
  public UpdateMemberDTO(String memberId, String memberName) {
    this.memberId = memberId;
    this.memberName = memberName;
  }

  /**
   * 更新房间成员构造方法
   * 
   * @param memberId 成员id，不允许为空
   * @param memberName 成员名称，不允许为空
   * @param roomId 房间ID
   */
  public UpdateMemberDTO(String memberId, String memberName, String roomId) {
    this(memberId, memberName);
    this.roomId = roomId;
  }
  
  /**
   * 更新房间成员构造方法
   * 
   * @param memberId 成员id，不允许为空
   * @param memberName 成员名称，不允许为空
   * @param roomId 房间ID
   * @param memberType 成员类型
   * @param title 成员title
   */
  public UpdateMemberDTO(String memberId, String memberName, String roomId, String memberType,
      String title) {
    this(memberId, memberName);
    this.roomId = roomId;
    this.memberType = memberType;
    this.title = title;
  }
}
