package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.enums.MemberStatusEnums;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class UpdateMemberStatusReqDTO implements Serializable {
  
  /**
   * 
   */
  private static final long serialVersionUID = 6632802651895910352L;
  /**
   * 房间表主键ID
   */
  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  private String roomId;
  @NotNull(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String[] memberIds;
  @NotNull(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private MemberStatusEnums status;
}
