package com.beiming.basic.chat.api.dto.response;

import java.io.Serializable;
import java.util.Date;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.constants.ChatApiConstant;
import com.beiming.basic.chat.api.enums.ChatMessageTypeEnums;
import com.beiming.basic.chat.api.enums.MessageResourceEnums;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 聊天信息DTO
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class MessageResDTO implements Serializable {

  private static final long serialVersionUID = 6883973004860500452L;

  /**
   * 消息id
   */
  private Long id;
  
  /**
   * 房间id
   */
  private String roomId;
  /**
   * 发送人
   */
  private MemberResDTO sender;
  /**
   * 接收人
   */
  private MemberResDTO receiver;
  /**
   * 消息类型
   */
  private ChatMessageTypeEnums messageType;

  /**
   * 消息来源
   */
  private MessageResourceEnums messageResource;
  
  /**
   * 消息内容
   */
  private String messageContent;
  /**
   * CategoryBigEnums
   */
  private String categoryBig;
  /**
   * 发送时间
   */
  private Date createTime;
  /**
   * 消息接收人名称
   */
  private String receiverNames;

  /**
   * 是否上传至证据YES表示上传
   */
  private String fileStatus;

  /**
   * 消息已读成员的id
   */
  private String userIds;

  /**
   * 消息是否能够撤回
   */
  private boolean revocable;

  /**
   * 可见范围
   */
  private String visiblePermission;
  
  /**
   * 如果 messageType 为文件，则返回文件id，否则为空
   * 
   * @return
   */
  public String getFileId() {
    if (messageType == ChatMessageTypeEnums.FILE) {
      JSONObject json = JSONObject.parseObject(messageContent);
      return json.getString(ChatApiConstant.FILE_ID_KEY);
    }
    return null;
  }

  /**
   * 如果 messageType 为文件，则返回文件名，否则为空
   * 
   * @return
   */
  public String getFileName() {
    if (messageType == ChatMessageTypeEnums.FILE) {
      JSONObject json = JSONObject.parseObject(messageContent);
      return json.getString(ChatApiConstant.FILE_NAME_KEY);
    }
    return null;
  }
}
