package com.beiming.basic.chat.api.dto.response;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.beiming.basic.chat.api.dto.request.RoomAttributesDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 房间信息dto
 * 
 * @author djq
 *
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class RoomInfoResDTO extends RoomResDTO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = -3614325905865482681L;

  /**
   * 房间主键Id
   */
  private String id;
  
  /**
   * 业务房间Id
   */
  private String bizRoomId;
  
  /**
   * 业务房间Type
   */
  private String bizRoomType;
  
  /**
   * 房间属性
   */
  private RoomAttributesDTO roomAttributes;
  
  /**
   * 房间状态<br>
   * 
   * 初始化 INIT<br>
   * 进行中 RUNNING<br>
   * 已结束 END<br>
   * 
   * @see RoomStatusEnums
   */
  //  private String roomStatus;

  /**
   * 最后消息
   */
  private String lastMessage;

  /**
   * 最后消息时间
   */
  private Date lastMessageTime;
 
  /**
   * 未读消息数
   */
  private Integer unreadMessageCount;
  
  /**
   * remark(房间属性)
   */
  private String remark;
  

  @Override
  public String toString() {
    return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
  }

}
