package com.beiming.basic.chat.api;

import com.beiming.basic.chat.api.dto.request.InsertTempMemberInfoReqDTO;
import com.beiming.basic.chat.api.dto.response.TempMemberInfoResDTO;
import com.beiming.framework.domain.DubboResult;

public interface TempMemberInfoApi {
  /**
   * 根据房间号查询临时成员
   * 
   * @param roomId
   * @return
   */
  DubboResult<TempMemberInfoResDTO> selectTempMemberInfo(String roomId);

  /**
   * 新增临时成员信息
   * 
   * @param dto
   * @return
   */
  DubboResult<Integer> insertTempMemberInfo(InsertTempMemberInfoReqDTO dto);

  /**
   * 闭庭时修改临时成员标识
   * @param roomId
   * @return
   */
  DubboResult<Integer> updateTempMemberStatus(String roomId);
}
