package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.constants.ChatApiConstant;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 新建房间dto
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("serial")
public class DelChatRecordReqDTO implements Serializable {

  /**
   * 业务id,案件ID
   */
  @NotBlank(message = ChatApiValidationMessage.SUBJECT_ID_NOT_BLANK)
  @Size(max = ChatApiConstant.SUBJECT_ID_MAX_SIZE,
      message = ChatApiValidationMessage.SUBJECT_ID_TOO_LONG)
  protected String subjectId;
  
  protected String roomId;
  /**
   * 内容片断
   */
  @NotBlank(message = "内容片断不能为空")
  protected String contentSnippet;
  /**
   * 消息类型
   */
  protected String messageType;
  public DelChatRecordReqDTO(
      @NotBlank(message = "业务id不允许为空") @Size(max = 60, message = "业务类型ID超过限制") String subjectId,
      @NotBlank(message = "内容片断不能为空") String contentSnippet, String messageType) {
    super();
    this.subjectId = subjectId;
    this.contentSnippet = contentSnippet;
    this.messageType = messageType;
  }
  
}
