package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
/**
 * 情绪识别
 * @author ljf
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class EmotionalRecognitionReqDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 4291449205793493618L;

  /**
   * 房间号
   */
  @NotNull(message = "房间号不能为空")
  private Long roomId;

  /**
   * 成员id
   */
  @NotNull(message = "成员id不能为空")
  private Long memberId;
  /**
   * 成员名称
   */
  @NotNull(message = "成员名称不能为空")
  private String memberName;

  /**
   * 平静
   */
  @NotNull(message = "平静值不能为空")
  private BigDecimal neutral;

  /**
   * 悲伤
   */
  @NotNull(message = "悲伤值不能为空")
  private BigDecimal sadness;

  /**
   * 厌恶
   */
  @NotNull(message = "厌恶值不能为空")
  private BigDecimal disgust;

  /**
   * 愤怒
   */
  @NotNull(message = "愤怒值不能为空")
  private BigDecimal anger;

  /**
   * 惊奇
   */
  @NotNull(message = "惊奇值不能为空")
  private BigDecimal surprise;

  /**
   * 恐惧
   */
  @NotNull(message = "恐惧值不能为空")
  private BigDecimal fear;

  /**
   * 高兴
   */
  @NotNull(message = "高兴值不能为空")
  private BigDecimal happiness;

  /**
   * 发生时间
   */
  @NotNull(message = "发生时间不能为空")
  private Date secTime;
  /**
   * 发生时间 TimeMillis
   */
  @NotNull(message = "发生时间不能为空")
  private Long secTimeMillis;

  /**
   * prefix
   */
  @NotBlank(message = "prefix不能为空")
  private String prefix;

  /**
   * 系统标识
   */
  private String sys;
}
