package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.enums.ChatMessageTypeEnums;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 查看房间所有消息
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class ListAllMessageReqDTO implements Serializable {

  private static final long serialVersionUID = -8275151074964279508L;
  /**
   * 房间id
   */
  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  private String roomId;
  /**
   * 接收人id
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String receiverId;
  /**
   * 消息类型
   */
  private ChatMessageTypeEnums messageType;
  /**
   * 发送人id
   */
  private String senderId;
  /**
   * 开始id
   * 
   * 获取该id之后的消息记录
   */
  private Long startId;
  /**
   * 开始时间
   * 
   * 获取该时间之后的消息记录
   */
  private Date startTime;
  /**
   * 文件类型
   *
   * @see com.beiming.basic.chat.api.enums.CategoryBigEnums
   */
  private String categoryBig;
  /**
   * 搜索关键词
   */
  private String keyword;
  
  /**
   * 复用的sql有该字段判断
   */
  private Integer evidenceType;

  public ListAllMessageReqDTO(String roomId, String receiverId) {
    this.roomId = roomId;
    this.receiverId = receiverId;
  }
}
