package com.beiming.basic.chat.api.dto.request;

import java.util.Date;
import javax.validation.constraints.NotBlank;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.enums.ChatMessageTypeEnums;
import com.beiming.framework.page.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 分页查看消息
 * 
 * @author lb
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class ListMessageReqDTO extends PageQuery {

  private static final long serialVersionUID = -8275151074964279508L;

  /**
   * 房间id
   */
  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  private String roomId;


  /**
   * 接收人id
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String receiverId;
  /**
   * 消息类型
   */
  private ChatMessageTypeEnums messageType;
  /**
   * 发送人id
   */
  private String senderId;
  /**
   * 开始id
   * 
   * 获取该id之后的消息记录
   */
  private Long startId;
  /**
   * 开始时间
   * 
   * 获取该时间之后的消息记录
   */
  private Date startTime;


  /**
   * 消息时间筛选开始时间
   */
  private String msgStartTime;

  /**
   * 消息时间筛选结束时间
   */
  private String msgEndTime;

  
  private String keyword;

  /**
   * 文件类型
   *
   * @see com.beiming.basic.chat.api.enums.CategoryBigEnums
   */
  private String categoryBig;
  
  /**
   * 为1时过滤证据材料，其他值或不传则不过滤
   */
  private Integer evidenceType;

  private String searchContent;

  private Integer kindParam;

  public ListMessageReqDTO(String roomId, String receiverId) {
    this.roomId = roomId;
    this.receiverId = receiverId;
    this.setPageIndex(1);
    this.setPageSize(10);
  }

  public ListMessageReqDTO(String roomId, String receiverId, Integer pageIndex, Integer pageSize) {
    super(pageIndex, pageSize);
    this.roomId = roomId;
    this.receiverId = receiverId;
  }

  public ListMessageReqDTO(String roomId, String receiverId, Integer pageIndex, Integer pageSize, Long startId) {
    super(pageIndex, pageSize);
    this.roomId = roomId;
    this.receiverId = receiverId;
    this.startId = startId;
  }
  
  public ListMessageReqDTO(String roomId, String receiverId, String senderId, Integer pageSize,
      Integer pageIndex, Date startTime) {
    super(pageIndex, pageSize);
    this.roomId = roomId;
    this.receiverId = receiverId;
    this.senderId = senderId;
    this.startTime = startTime;
  }
}
