package com.beiming.basic.chat.api.dto.request;

import com.beiming.basic.chat.api.ChatApiValidationMessage;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 分页查看个人待办列表
 * 
 * @author chenjt
 *
 * 2019-01-18 15:00:00
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class ListUserRoomReqDTO implements Serializable {


  private static final long serialVersionUID = 950922687650374525L;
  /**
   * 成员id
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String memberId;

  /**
   * 成员类型<br>
   *
   * 管理员 MASTER<br>
   * 普通参与人 NORMAL
   *
   * @see MemberRoleTypeEnums
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_TYPE_NOT_BLANK)
  private String memberRoleType;

  /**
   * 当天日期
   */
  private String currentDate;

  /**
   * 房间类型<br>
   * 业务层面上的房间类型<br>
   * 对应subject_type
   */
  private String businessRoomType;

  public ListUserRoomReqDTO(String memberId, String memberRoleType) {
    this.memberId = memberId;
    this.memberRoleType = memberRoleType;
  }

  public ListUserRoomReqDTO(String memberId, String memberRoleType, String businessRoomType) {
    this.memberId = memberId;
    this.memberRoleType = memberRoleType;
    this.businessRoomType = businessRoomType;
  }

}
