package com.beiming.basic.chat.api.dto.request;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.constants.ChatApiConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class SendFileMessageReqDTO extends SendMessageReqDTO {


  private static final long serialVersionUID = -1271793729230614248L;

  @NotBlank(message = ChatApiValidationMessage.FILE_ID_NOT_BLANK)
  @Size(max = ChatApiConstant.FILE_ID_MAX_SIZE, message = ChatApiValidationMessage.FILE_ID_TOO_LONG)
  private String fileId;

  @NotBlank(message = ChatApiValidationMessage.FILE_NAME_NOT_BLANK)
  @Size(max = ChatApiConstant.FILE_NAME_MAX_SIZE,
      message = ChatApiValidationMessage.FILE_NAME_TOO_LONG)
  private String fileName;
  
  private String filePath;
  
  /**
   * 音视频文件时长
   */
  private String mediaLength;
  /**
   * 文件类型
   *
   * @see com.beiming.basic.chat.api.enums.CategoryBigEnums
   */
  private String categoryBig;

  /**
   *查询的相关内容
   */
  private String searchContent;

  /**
   * 已读消息人员id
   */
  private String readUserIds;

  public SendFileMessageReqDTO(String roomId, String senderId, String fileId, String fileName) {
    super(roomId, senderId);
    this.fileId = fileId;
    this.fileName = fileName;
  }

  public SendFileMessageReqDTO(String roomId, String senderId, String receiverId, String fileId,
      String fileName) {
    super(roomId, senderId, receiverId);
    this.fileId = fileId;
    this.fileName = fileName;
  }
}
