package com.beiming.basic.chat.api.dto.request;

import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.constants.ChatApiConstant;
import com.beiming.basic.chat.api.enums.MessageResourceEnums;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @Description: 系统类消息请求参数
 * @Author: caiwei
 * @Date: 2019/1/18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class SendSystemMessageReqDTO extends SendMessageReqDTO {

  private static final long serialVersionUID = -2052231468361802924L;

  /**
   * 发送人姓名
   */
  private String senderName;

  /**
   * 接收人姓名
   */
  private String receiverName;

  /**
   * 消息来源
   */
  private MessageResourceEnums messageResource;

  /**
   * 消息内容
   */
  @NotBlank(message = ChatApiValidationMessage.SEND_CONTENT_NOT_BLANK)
  @Size(max = ChatApiConstant.MESSAGE_CONTENT_MAX_SIZE,
      message = ChatApiValidationMessage.SEND_CONTENT_TOO_LONG)
  private String messageContent;

}