package com.beiming.basic.chat.api.dto.request;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.constants.ChatApiConstant;
import com.beiming.basic.chat.api.enums.ChatMessageTypeEnums;
import com.beiming.basic.chat.api.enums.MessageResourceEnums;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class SendTextMessageReqDTO extends SendMessageReqDTO {

  private static final long serialVersionUID = -1298142885154912794L;

  /**
   * 消息内容
   */
  @NotBlank(message = ChatApiValidationMessage.SEND_CONTENT_NOT_BLANK)
  @Size(max = ChatApiConstant.MESSAGE_CONTENT_MAX_SIZE,
      message = ChatApiValidationMessage.SEND_CONTENT_TOO_LONG)
  private String messageContent;

  //  @NotEmpty(message = ChatApiValidationMessage.SEND_MESSAGE_RESOURCE_NOT_BLANK)
  private MessageResourceEnums messageResource;
  /**
   * messageType细分类
   */
  private String categoryBig;
  /**
   * 消息接收人名称
   */
  private String receiverNames;
  
  private ChatMessageTypeEnums messageType;
  /**
   *证据上传时，相关文件名称等
   */
  private String searchContent;
  /**
   * 质证的会议用户人员类型
   */
  private String meetingUserType;
  /**
   * 质证的证据id
   */
  private String proofMsgId;
  /**
   * 已读消息人员id
   */
  private String readUserIds;
  public SendTextMessageReqDTO(String roomId, String senderId, String messageContent,
      MessageResourceEnums... messageResourceEnums) {
    super(roomId, senderId);
    this.messageContent = messageContent;
    if (messageResourceEnums != null && messageResourceEnums.length > 0) {
      MessageResourceEnums enums = messageResourceEnums[0];
      this.messageResource = enums == null ? MessageResourceEnums.INVITATION_VIDEO : enums;
    }
  }

  public SendTextMessageReqDTO(String roomId, String senderId, String receiverId,
      String messageContent, String readUserIds, MessageResourceEnums... messageResourceEnums) {
    super(roomId, senderId, receiverId);
    this.messageContent = messageContent;
    this.readUserIds = readUserIds;
    if (messageResourceEnums != null && messageResourceEnums.length > 0) {
      MessageResourceEnums enums = messageResourceEnums[0];
      this.messageResource = enums == null ? MessageResourceEnums.HANDLER_INPUT : enums;
    }
  }

  public SendTextMessageReqDTO(String roomId, String senderId, String receiverId,
      String messageContent, MessageResourceEnums... messageResourceEnums) {
    super(roomId, senderId, receiverId);
    this.messageContent = messageContent;
    if (messageResourceEnums != null && messageResourceEnums.length > 0) {
      MessageResourceEnums enums = messageResourceEnums[0];
      this.messageResource = enums == null ? MessageResourceEnums.HANDLER_INPUT : enums;
    }
  }
  
  public SendTextMessageReqDTO(String roomId, String senderId, 
      String messageContent, MessageResourceEnums messageResourceEnums, String categoryBig) {
    super(roomId, senderId);
    this.messageContent = messageContent;
    this.messageResource = messageResourceEnums;
    this.categoryBig = categoryBig;
  }
}
