package com.beiming.basic.chat.api.dto.request;

import com.beiming.framework.message.BaseMessageDto;
import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class SendVoiceMessageReqDTO extends BaseMessageDto implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = 3610378109720033522L;

  /**
   * <pre>
   * 通话状态标识
   */
  private String callStatus;

  /**
   * <pre>
   * 消息使用状态
   * 0:使用
   * 1:删除
   */
  private String msgStatus;
  /**
   * <pre>
   * 通话结果信息
   */
  private String message;

  /**
   * 房间主键id
   */
  protected String roomId;
  /**
   * 发送人id
   */
  protected String senderId;
  /**
   * 接收人id
   */
  protected String receiverId;


  /**
   * 消息id
   */
  private Long msgId;
  /**
   * 案件空间中的会议id
   */
  private String subjectId;

  public SendVoiceMessageReqDTO(String roomId, String memberId, String receiverId,
      String callStatus, String msg, String msgStatus, Long msgId) {
    this.roomId = roomId;
    this.senderId = memberId;
    this.receiverId = receiverId;
    this.callStatus = callStatus;
    this.message = msg;
    this.msgStatus = msgStatus;
    this.msgId = msgId;
  }
}
