package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 更新异步调节房间人员
 * 
 * @author huaisf
 *
 */
@Data
public class UpdateMemberUserReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * 房间id
   */
  private String roomId;

  /**
   * 修改人员
   */
  private List<MemberReqDTO> updateList;

  /**
   * 删除人员
   */
  private List<MemberReqDTO> deleteList;

  /**
   * 新增人员
   */
  private List<MemberReqDTO> addList;


  public UpdateMemberUserReqDTO(String roomId, List<MemberReqDTO> updateList,
      List<MemberReqDTO> deleteList, List<MemberReqDTO> addList) {
    this.roomId = roomId;
    this.updateList = updateList;
    this.deleteList = deleteList;
    this.addList = addList;
  }
}
