package com.beiming.basic.chat.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * Created by zli on 2019/1/21.
 *
 * 聊天文件类型
 */
@Getter
@NoArgsConstructor
@AllArgsConstructor
public enum CallStatusEnums {
  START("发起语音通话", "发起语音通话"),
  INTERRUPT("通话中断", "通话中断"),
  NO_ANSWER("无人接听", "对方无应答"),
  CANCEL("取消通话", "已取消"),
  RECEIVE("接听通话", "已接听"),
  REJECT("拒绝通话", "已拒绝"),
  END("挂断语音通话", "通话结束"),
  HEARTBEAT("语音通话心跳事件", "心跳"),
  BUSY("正处于语音通话中", "正在通话中，请稍后再拨!"),
  DROPPED_CALL("通话结束，中断通话状态", "通话结束，中断通话状态，间隔15秒钟，阻止用户继续收到发起通话事件"),

 ;

  private String operation;
  private String msg;


}
