package com.beiming.basic.chat.api;

import com.beiming.basic.chat.api.dto.request.StreamInfo;
import com.beiming.basic.chat.api.dto.request.StreamListMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.UpdateMemberStatusReqDTO;
import java.util.ArrayList;
import java.util.Date;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import com.beiming.basic.chat.api.dto.request.AppendMemberDTO;
import com.beiming.basic.chat.api.dto.request.ChatRoomReqDTO;
import com.beiming.basic.chat.api.dto.request.DeleteMemberReqDTO;
import com.beiming.basic.chat.api.dto.request.JoinRoomReqDTO;
import com.beiming.basic.chat.api.dto.request.ListAllMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.ListMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.LoadMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.RoomMemberReqDTO;
import com.beiming.basic.chat.api.dto.request.SaveMemberVideoInfoReqDTO;
import com.beiming.basic.chat.api.dto.request.SaveRoomVideoInfoReqDTO;
import com.beiming.basic.chat.api.dto.request.SendFileMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.SendTextMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.VideoRoomReqDTO;
import com.beiming.basic.chat.api.dto.response.MessageResDTO;
import com.beiming.basic.chat.api.dto.response.RoomResDTO;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;

/**
 * 聊天、视频服务
 * 
 * @author lb
 *
 */
@Valid
public interface RoomApi {

  /**
   * 新建对话聊天室
   * 
   * @param dto
   * @return roomId
   */
  DubboResult<String> newChatRoom(@Valid ChatRoomReqDTO dto);

  /**
   * 新建视频房间
   * 
   * @param dto
   * @return roomId
   */
  DubboResult<String> newVideoRoom(@Valid VideoRoomReqDTO dto);

  /**
   * 新建视频房间，并限制开始结束时间
   * 
   * @param dto
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return roomId
   */
  DubboResult<String> newVideoRoom(@Valid VideoRoomReqDTO dto,
      @NotNull(message = ChatApiValidationMessage.ROOM_START_TIME_NOT_NULL) Date startTime,
      @NotNull(message = ChatApiValidationMessage.ROOM_END_TIME_NOT_NULL) Date endTime);

  /**
   * 获取房间信息
   * 
   * @param roomId 房间id
   * @return
   */
  DubboResult<RoomResDTO> getRoom(
      @Valid @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK) String roomId);


  /**
   * 发送文本消息
   * 
   * @param dto
   */
  DubboResult<MessageResDTO> sendTextMessage(@Valid SendTextMessageReqDTO dto);

  /**
   * 发送文件
   * 
   * @param dto
   */
  DubboResult<MessageResDTO> sendFileMessage(@Valid SendFileMessageReqDTO dto);

  /**
   * 分页获取聊天消息
   * 
   * @param roomId 房间id
   * @param memberId 成员id
   * @return
   */
  DubboResult<PageInfo<MessageResDTO>> listMessage(@Valid ListMessageReqDTO dto);

  /**
   * 流式分页获取聊天消息
   *
   * @param roomId 房间id
   * @param memberId 成员id
   * @return
   */
  DubboResult<PageInfo<MessageResDTO>> streamListMessage(@Valid StreamListMessageReqDTO dto);


  /**
   * 获取单个房间内，单个成员的聊天消息
   * 
   * @param roomId 房间id
   * @param memberId 成员id
   * @return
   */
  DubboResult<ArrayList<MessageResDTO>> listAllMessage(@Valid ListAllMessageReqDTO dto);


  /**
   * 获取单条消息
   * 
   * @param dto
   * @return
   */
  DubboResult<MessageResDTO> loadMessage(@Valid LoadMessageReqDTO dto);

  /**
   * 追加成员
   * 
   * @param dto
   * @return
   */
  DubboResult<RoomResDTO> appendMember(@Valid AppendMemberDTO dto);

  /**
   * 进入房间
   * 
   * @param dto
   * @return
   */
  DubboResult<RoomResDTO> joinRoom(@Valid JoinRoomReqDTO dto);

  /**
   * 退出房间
   * 
   * @param dto
   * @return
   */
  DubboResult<RoomResDTO> quitRoom(@Valid RoomMemberReqDTO dto);

  /**
   * 结束房间
   * 
   * @param dto
   * @return
   */
  DubboResult<Boolean> closeRoom(@Valid RoomMemberReqDTO dto);

  /**
   * 保存混流视频信息
   * 
   * @return
   */
  DubboResult<Boolean> saveRoomMixVideoInfo(@Valid SaveRoomVideoInfoReqDTO dto);

  /**
   * 保存单个成员视频信息
   * 
   * @return
   */
  DubboResult<Boolean> saveRoomMemberVideoInfo(@Valid SaveMemberVideoInfoReqDTO dto);
  
  /**
   * 删除视频人员信息
   * 
   * @return
   */
  DubboResult<Boolean> deleteRoomMember(@Valid DeleteMemberReqDTO dto);

  /**
   * 发送视频流信息
   * @param streamInfo
   * @return
   */
  DubboResult<Boolean> sendStreamInfo(@Valid StreamInfo streamInfo);

  /**
   * 更新成员状态
   *
   * @return
   */
  DubboResult<Boolean> updateMemberStatus(@Valid UpdateMemberStatusReqDTO dto);
}
