package com.beiming.basic.chat.api.dto.request;

import com.beiming.basic.chat.api.ChatApiValidationMessage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
/**
 * 情绪识别
 * @author ljf
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class EmotionalRecognitionReqDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 4291449205793493618L;

  /**
   * 房间号
   */
  @NotNull(message = ChatApiValidationMessage.ROOM_NUMBER_CANNOT_BE_EMPTY)
  private Long roomId;

  /**
   * 成员id
   */
  @NotNull(message = ChatApiValidationMessage.MEMBER_ID_CANNOT_BE_EMPTY)
  private Long memberId;
  /**
   * 成员名称
   */
  @NotNull(message = ChatApiValidationMessage.MEMBER_NAME_CANNOT_BE_EMPTY)
  private String memberName;

  /**
   * 平静
   */
  @NotNull(message = ChatApiValidationMessage.CALM_VALUE_CANNOT_BE_EMPTY)
  private BigDecimal neutral;

  /**
   * 悲伤
   */
  @NotNull(message = ChatApiValidationMessage.SAD_VALUE_CANNOT_BE_EMPTY)
  private BigDecimal sadness;

  /**
   * 厌恶
   */
  @NotNull(message = ChatApiValidationMessage.DISGUST_VALUE_CANNOT_BE_EMPTY)
  private BigDecimal disgust;

  /**
   * 愤怒
   */
  @NotNull(message = ChatApiValidationMessage.RAGE_VALUE_CANNOT_BE_EMPTY)
  private BigDecimal anger;

  /**
   * 惊奇
   */
  @NotNull(message = ChatApiValidationMessage.SURPRISE_VALUE_CANNOT_BE_EMPTY)
  private BigDecimal surprise;

  /**
   * 恐惧
   */
  @NotNull(message = ChatApiValidationMessage.FEAR_VALUE_CANNOT_BE_EMPTY)
  private BigDecimal fear;

  /**
   * 高兴
   */
  @NotNull(message = ChatApiValidationMessage.HAPPY_VALUE_CANNOT_BE_EMPTY)
  private BigDecimal happiness;

  /**
   * 发生时间
   */
  @NotNull(message = ChatApiValidationMessage.OCCURRENCE_TIME_CANNOT_BE_EMPTY)
  private Date secTime;
  /**
   * 发生时间 TimeMillis
   */
  @NotNull(message = ChatApiValidationMessage.OCCURRENCE_TIME_CANNOT_BE_EMPTY)
  private Long secTimeMillis;

  /**
   * prefix
   */
  @NotBlank(message = ChatApiValidationMessage.PREFIX_CANNOT_BE_EMPTY)
  private String prefix;

  /**
   * 系统标识
   */
  private String sys;
}
