package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.constants.ChatApiConstant;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 房间成员实体类
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class MemberReqDTO implements Serializable {

  private static final long serialVersionUID = -2274691124620422737L;
  /**
   * 成员id
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  @Size(max = ChatApiConstant.MEMBER_ID_MAX_SIZE,
      message = ChatApiValidationMessage.MEMBER_ID_TOO_LONG)
  private String memberId;

  /**
   * 当事人id （为代理人时才有）
   */
  @Size(max = ChatApiConstant.MEMBER_ID_MAX_SIZE,
      message = ChatApiValidationMessage.MEMBER_ID_TOO_LONG)
  private String litigantId;
  /**
   * 成员名称
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_NAME_NOT_BLANK)
  @Size(max = ChatApiConstant.MEMBER_NAME_MAX_SIZE,
      message = ChatApiValidationMessage.MEMBER_NAME_TOO_LONG)
  private String memberName;
  /**
   * 成员类型
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_TYPE_NOT_BLANK)
  @Size(max = ChatApiConstant.MEMBER_TYPE_MAX_SIZE,
      message = ChatApiValidationMessage.MEMBER_TYPE_TOO_LONG)
  private String memberType;
  /**
   * 代理人类型（为代理人时才有）
   */
  @Size(max = ChatApiConstant.MEMBER_TYPE_MAX_SIZE,
      message = ChatApiValidationMessage.MEMBER_TYPE_TOO_LONG)
  private String agentType;
  /**
   * 是否为管理员
   */
  private boolean master;

  /**
   * 房间成员构造方法
   * 
   * @param memberId 成员id，不允许为空
   * @param memberName 成员名称，不允许为空
   * @param memberType 成员类型，不允许为空
   */
  public MemberReqDTO(String memberId, String memberName, String memberType) {
    this.memberId = memberId;
    this.memberName = memberName;
    this.memberType = memberType;
  }

  /**
   * 房间成员构造方法
   * 
   * @param memberId 成员id，不允许为空
   * @param memberName 成员名称，不允许为空
   * @param memberType 成员类型，不允许为空
   * @param master 是否为房间管理员
   */
  public MemberReqDTO(String memberId, String memberName, String memberType, boolean master) {
    this(memberId, memberName, memberType);
    this.master = master;
  }
}
