package com.beiming.basic.chat.api.dto.request;

import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.enums.ChatMessageTypeEnums;
import com.beiming.framework.page.PageQuery;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 分页查看消息
 *
 * @author lb
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class StreamListMessageReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -8275151074964279508L;

  /**
   * 房间id
   */
  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  private String roomId;
  /**
   * 接收人id
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String receiverId;
  /**
   * 消息类型
   */
  private ChatMessageTypeEnums messageType;
  /**
   * 发送人id
   */
  private String senderId;
  /**
   * 开始id
   *
   * 获取该id之后的消息记录
   */
  private Long startId;
  /**
   * 开始时间
   *
   * 获取该时间之后的消息记录
   */
  private Date startTime;

  public StreamListMessageReqDTO(String roomId, String receiverId) {
    this.roomId = roomId;
    this.receiverId = receiverId;
    this.setPageIndex(1);
    this.setPageSize(10);
  }

  public StreamListMessageReqDTO(String roomId, String receiverId,
      Integer pageSize) {
    super(1, pageSize);
    this.roomId = roomId;
    this.receiverId = receiverId;
  }

  public StreamListMessageReqDTO(String roomId, String receiverId,
      Integer pageSize, Long startId) {
    super(1, pageSize);
    this.roomId = roomId;
    this.receiverId = receiverId;
    this.startId = startId;
  }
}
