package com.beiming.basic.chat.api.dto.response;

import java.io.Serializable;
import java.util.ArrayList;
import com.beiming.basic.chat.api.enums.EmotionalEnums;
import lombok.Data;
import lombok.NoArgsConstructor;
@Data
@NoArgsConstructor
public class EmotionalRecognitionStatisticsResDTO implements Serializable {

  
  /**
   * 
   */
  private static final long serialVersionUID = 2474887729002130220L;

  private String roomId;
  
  private String memberId;
  
  private String memberName;
  
  /**
   * 最大值的表情
   */
  private EmotionalEnums maxEmotional;
  /**
   * 分段柱状图数据
   */
  private ArrayList<SegmentedEmotionalRecognitionResDTO> segmentList;
  /**
   * 情绪识别总体分布
   */
  private SegmentedEmotionalRecognitionResDTO totalDistribution;
  /**
   * 详细数据
   */
//  private ArrayList<EmotionalRecognitionResDTO> detailList;
  public EmotionalRecognitionStatisticsResDTO(String roomId, String memberId, String memberName) {
    super();
    this.roomId = roomId;
    this.memberId = memberId;
    this.memberName = memberName;
  }
  
  
}
